/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.configuration;

import com.usthe.sureness.mgt.SecurityManager;
import com.usthe.sureness.processor.exception.DisabledAccountException;
import com.usthe.sureness.processor.exception.ExcessiveAttemptsException;
import com.usthe.sureness.processor.exception.ExpiredCredentialsException;
import com.usthe.sureness.processor.exception.IncorrectCredentialsException;
import com.usthe.sureness.processor.exception.NeedDigestInfoException;
import com.usthe.sureness.processor.exception.UnauthorizedException;
import com.usthe.sureness.processor.exception.UnknownAccountException;
import com.usthe.sureness.subject.SubjectSum;
import com.usthe.sureness.util.SurenessContextHolder;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;

public class SurenessJakartaServletFilter
implements Filter {
    private final SecurityManager securityManager;
    private static final Logger logger = LoggerFactory.getLogger(SurenessJakartaServletFilter.class);
    private static final String UPGRADE = "Upgrade";
    private static final String WEBSOCKET = "websocket";

    public SurenessJakartaServletFilter(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public void init(FilterConfig filterConfig) {
        logger.info("servlet surenessFilter initialized");
    }

    public void destroy() {
        logger.info("servlet surenessFilter destroyed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            SubjectSum subject = this.securityManager.checkIn((Object)servletRequest);
            if (subject != null) {
                SurenessContextHolder.bindSubject((SubjectSum)subject);
            }
        }
        catch (ExpiredCredentialsException | IncorrectCredentialsException | UnknownAccountException e1) {
            logger.debug("this request account info is illegal, {}", (Object)e1.getMessage());
            SurenessJakartaServletFilter.responseWrite(ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Username or password is incorrect or token expired"), servletResponse);
            return;
        }
        catch (DisabledAccountException | ExcessiveAttemptsException e2) {
            logger.debug("the account is disabled, {}", (Object)e2.getMessage());
            SurenessJakartaServletFilter.responseWrite(ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Account is disabled"), servletResponse);
            return;
        }
        catch (NeedDigestInfoException e3) {
            logger.debug("you should try once again with digest auth information");
            SurenessJakartaServletFilter.responseWrite(((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).header("WWW-Authenticate", new String[]{e3.getAuthenticate()})).build(), servletResponse);
            return;
        }
        catch (UnauthorizedException e4) {
            logger.debug("this account can not access this resource, {}", (Object)e4.getMessage());
            SurenessJakartaServletFilter.responseWrite(ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)"This account has no permission to access this resource"), servletResponse);
            return;
        }
        catch (RuntimeException e) {
            logger.error("other exception happen: ", (Throwable)e);
            SurenessJakartaServletFilter.responseWrite(ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build(), servletResponse);
            return;
        }
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            int statusCode = ((HttpServletResponse)servletResponse).getStatus();
            String upgrade = ((HttpServletResponse)servletResponse).getHeader(UPGRADE);
            if (statusCode != HttpStatus.SWITCHING_PROTOCOLS.value() || !WEBSOCKET.equals(upgrade)) {
                SurenessContextHolder.clear();
            }
        }
    }

    private static void responseWrite(ResponseEntity content, ServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        ((HttpServletResponse)response).setStatus(content.getStatusCodeValue());
        content.getHeaders().forEach((key, value) -> ((HttpServletResponse)response).addHeader(key, (String)value.get(0)));
        try (PrintWriter printWriter = response.getWriter();){
            if (content.getBody() != null) {
                printWriter.write(content.getBody().toString());
            } else {
                printWriter.flush();
            }
        }
        catch (IOException e) {
            logger.error("responseWrite response error: ", (Throwable)e);
        }
    }
}

