/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.tcp.discovery;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcDiscoveryItem;
import org.apache.plc4x.java.api.messages.PlcDiscoveryItemHandler;
import org.apache.plc4x.java.api.messages.PlcDiscoveryRequest;
import org.apache.plc4x.java.api.messages.PlcDiscoveryResponse;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.modbus.readwrite.DriverType;
import org.apache.plc4x.java.modbus.readwrite.ModbusConstants;
import org.apache.plc4x.java.modbus.readwrite.ModbusErrorCode;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUError;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadCoilsRequest;
import org.apache.plc4x.java.modbus.readwrite.ModbusTcpADU;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;
import org.apache.plc4x.java.spi.messages.DefaultPlcDiscoveryItem;
import org.apache.plc4x.java.spi.messages.DefaultPlcDiscoveryResponse;
import org.apache.plc4x.java.spi.messages.PlcDiscoverer;
import org.apache.plc4x.java.utils.rawsockets.netty.utils.ArpUtils;
import org.pcap4j.core.PcapNetworkInterface;
import org.pcap4j.core.Pcaps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusPlcDiscoverer
implements PlcDiscoverer {
    private final Logger logger = LoggerFactory.getLogger(ModbusPlcDiscoverer.class);

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    public CompletableFuture<PlcDiscoveryResponse> discover(PlcDiscoveryRequest discoveryRequest) {
        return this.discoverWithHandler(discoveryRequest, null);
    }

    public CompletableFuture<PlcDiscoveryResponse> discoverWithHandler(PlcDiscoveryRequest discoveryRequest, PlcDiscoveryItemHandler handler) {
        CompletableFuture<PlcDiscoveryResponse> future = new CompletableFuture<PlcDiscoveryResponse>();
        Thread discoveryThread = new Thread(() -> this.executeDiscovery(future, discoveryRequest, handler));
        discoveryThread.start();
        return future;
    }

    private void executeDiscovery(CompletableFuture<PlcDiscoveryResponse> future, PlcDiscoveryRequest discoveryRequest, PlcDiscoveryItemHandler handler) {
        List<Object> possibleAddresses = new ArrayList<InetAddress>();
        try {
            for (PcapNetworkInterface dev : Pcaps.findAllDevs()) {
                this.logger.info("Scanning network {} for alive IP addresses", (Object)dev.getName());
                Set inetAddresses = ArpUtils.scanNetworkDevice((PcapNetworkInterface)dev);
                this.logger.debug("Found {} addresses: {}", (Object)inetAddresses.size(), (Object)inetAddresses);
                possibleAddresses.addAll(inetAddresses);
            }
        }
        catch (Throwable e) {
            this.logger.error("Error collecting list of possible IP addresses", e);
            future.complete((PlcDiscoveryResponse)new DefaultPlcDiscoveryResponse(discoveryRequest, PlcResponseCode.INTERNAL_ERROR, Collections.emptyList()));
            return;
        }
        try {
            possibleAddresses.add(InetAddress.getByName("localhost"));
        }
        catch (UnknownHostException e) {
            throw new PlcRuntimeException((Throwable)e);
        }
        possibleAddresses = possibleAddresses.stream().filter(ModbusPlcDiscoverer.distinctByKey(InetAddress::getHostAddress)).collect(Collectors.toList());
        ConcurrentLinkedQueue discoveryItems = new ConcurrentLinkedQueue();
        ((Stream)possibleAddresses.stream().parallel()).forEach(possibleAddress -> {
            try {
                this.logger.info("Trying address: {}", possibleAddress);
                Socket socket = new Socket(possibleAddress.getHostAddress(), (int)ModbusConstants.MODBUSTCPDEFAULTPORT);
                this.logger.info("Connected: {}", possibleAddress);
                OutputStream outputStream = socket.getOutputStream();
                BufferedInputStream inputStream = new BufferedInputStream(socket.getInputStream());
                int transactionIdentifier = 1;
                short unitIdentifier = 1;
                while (unitIdentifier <= 247) {
                    block17: {
                        ModbusTcpADU packet = new ModbusTcpADU(transactionIdentifier++, unitIdentifier, new ModbusPDUReadCoilsRequest(1, 1));
                        byte[] deviceIdentificationBytes = null;
                        try {
                            WriteBufferByteBased writeBuffer = new WriteBufferByteBased(packet.getLengthInBytes());
                            packet.serialize((WriteBuffer)writeBuffer);
                            deviceIdentificationBytes = writeBuffer.getBytes();
                        }
                        catch (SerializationException e) {
                            this.logger.error("Error creating the device identification request", (Throwable)e);
                        }
                        if (deviceIdentificationBytes == null) {
                            future.complete((PlcDiscoveryResponse)new DefaultPlcDiscoveryResponse(discoveryRequest, PlcResponseCode.INTERNAL_ERROR, Collections.emptyList()));
                            return;
                        }
                        byte[] finalDeviceIdentificationBytes = deviceIdentificationBytes;
                        outputStream.write(finalDeviceIdentificationBytes);
                        outputStream.flush();
                        byte[] responseBytes = null;
                        long endTime = System.currentTimeMillis() + 100L;
                        while (responseBytes == null) {
                            if (((InputStream)inputStream).available() >= 6) {
                                ((InputStream)inputStream).mark(6);
                                ((InputStream)inputStream).skip(4L);
                                byte[] packetLengthBytes = new byte[2];
                                int bytesRead = ((InputStream)inputStream).read(packetLengthBytes);
                                ((InputStream)inputStream).reset();
                                if (bytesRead != 2) continue;
                                short packetLength = (short)(ByteBuffer.wrap(packetLengthBytes).getShort() + 6);
                                if (((InputStream)inputStream).available() < packetLength || (bytesRead = ((InputStream)inputStream).read(responseBytes = new byte[packetLength])) == packetLength) continue;
                                responseBytes = null;
                                break;
                            }
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                            if (System.currentTimeMillis() > endTime) break;
                        }
                        if (responseBytes != null) {
                            ReadBufferByteBased readBuffer = new ReadBufferByteBased(responseBytes);
                            try {
                                ModbusTcpADU response = (ModbusTcpADU)ModbusTcpADU.staticParse((ReadBuffer)readBuffer, DriverType.MODBUS_TCP, true);
                                boolean found = false;
                                if (response.getPdu().getErrorFlag().booleanValue()) {
                                    ModbusPDUError errorPdu = (ModbusPDUError)response.getPdu();
                                    if (errorPdu.getExceptionCode() == ModbusErrorCode.ILLEGAL_DATA_ADDRESS) {
                                        found = true;
                                    }
                                } else {
                                    found = true;
                                }
                                if (!found) break block17;
                                DefaultPlcDiscoveryItem discoveryItem = new DefaultPlcDiscoveryItem("modbus-tcp", "tcp", possibleAddress.getHostAddress(), Collections.singletonMap("unit-identifier", Integer.toString(unitIdentifier)), "unknown", Collections.emptyMap());
                                discoveryItems.add(discoveryItem);
                                if (handler != null) {
                                    handler.handle((PlcDiscoveryItem)discoveryItem);
                                }
                                break;
                            }
                            catch (ParseException parseException) {
                                // empty catch block
                            }
                        }
                    }
                    unitIdentifier = (short)(unitIdentifier + 1);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        future.complete((PlcDiscoveryResponse)new DefaultPlcDiscoveryResponse(discoveryRequest, PlcResponseCode.OK, Arrays.asList(discoveryItems.toArray(new PlcDiscoveryItem[0]))));
    }
}

