/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.asm;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import org.eclipse.persistence.asm.AnnotationVisitor;
import org.eclipse.persistence.asm.ClassReader;
import org.eclipse.persistence.asm.ClassVisitor;
import org.eclipse.persistence.asm.ClassWriter;
import org.eclipse.persistence.asm.FieldVisitor;
import org.eclipse.persistence.asm.Label;
import org.eclipse.persistence.asm.MethodVisitor;
import org.eclipse.persistence.asm.Opcodes;
import org.eclipse.persistence.asm.SerialVersionUIDAdder;
import org.eclipse.persistence.asm.Type;
import org.eclipse.persistence.asm.internal.platform.eclipselink.ClassReaderImpl;
import org.eclipse.persistence.asm.internal.platform.eclipselink.ClassWriterImpl;
import org.eclipse.persistence.asm.internal.platform.eclipselink.SerialVersionUIDAdderImpl;
import org.eclipse.persistence.asm.internal.platform.ow2.AnnotationVisitorImpl;
import org.eclipse.persistence.asm.internal.platform.ow2.ClassVisitorImpl;
import org.eclipse.persistence.asm.internal.platform.ow2.FieldVisitorImpl;
import org.eclipse.persistence.asm.internal.platform.ow2.LabelImpl;
import org.eclipse.persistence.asm.internal.platform.ow2.MethodVisitorImpl;
import org.eclipse.persistence.asm.internal.platform.ow2.TypeImpl;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLog;

public class ASMFactory {
    private static final SessionLog LOG = AbstractSessionLog.getLog();
    public static final String ASM_SERVICE_ECLIPSELINK = "eclipselink";
    public static final String ASM_SERVICE_OW2 = "ow2";
    private static final String ASM_OW2_CLASS_VISITOR = "org.objectweb.asm.ClassVisitor";
    private static final String ASM_ECLIPSELINK_CLASS_VISITOR = "org.eclipse.persistence.internal.libraries.asm.ClassVisitor";
    public static final int ASM_API_SELECTED = Opcodes.valueInt("ASM9");
    public static final int JAVA_CLASS_VERSION = Opcodes.valueInt("V1_8");
    public static final int JAVA_CLASS_LATEST_VERSION = ASMFactory.getLatestOPCodeVersion();

    public static AnnotationVisitor createAnnotationVisitor(int api) {
        String asmService = ASMFactory.getAsmService();
        if (ASM_SERVICE_ECLIPSELINK.equals(asmService)) {
            return new org.eclipse.persistence.asm.internal.platform.eclipselink.AnnotationVisitorImpl(api);
        }
        if (ASM_SERVICE_OW2.equals(asmService)) {
            return new AnnotationVisitorImpl(api);
        }
        throw ValidationException.notAvailableASMService();
    }

    public static AnnotationVisitor createAnnotationVisitor(int api, AnnotationVisitor annotationVisitor) {
        String asmService = ASMFactory.getAsmService();
        if (ASM_SERVICE_ECLIPSELINK.equals(asmService)) {
            return new org.eclipse.persistence.asm.internal.platform.eclipselink.AnnotationVisitorImpl(api, annotationVisitor);
        }
        if (ASM_SERVICE_OW2.equals(asmService)) {
            return new AnnotationVisitorImpl(api, annotationVisitor);
        }
        throw ValidationException.notAvailableASMService();
    }

    public static FieldVisitor createFieldVisitor(int api) {
        String asmService = ASMFactory.getAsmService();
        if (ASM_SERVICE_ECLIPSELINK.equals(asmService)) {
            return new org.eclipse.persistence.asm.internal.platform.eclipselink.FieldVisitorImpl(api);
        }
        if (ASM_SERVICE_OW2.equals(asmService)) {
            return new FieldVisitorImpl(api);
        }
        throw ValidationException.notAvailableASMService();
    }

    public static FieldVisitor createFieldVisitor(int api, FieldVisitor fieldVisitor) {
        String asmService = ASMFactory.getAsmService();
        if (ASM_SERVICE_ECLIPSELINK.equals(asmService)) {
            return new org.eclipse.persistence.asm.internal.platform.eclipselink.FieldVisitorImpl(api, fieldVisitor);
        }
        if (ASM_SERVICE_OW2.equals(asmService)) {
            return new FieldVisitorImpl(api, fieldVisitor);
        }
        throw ValidationException.notAvailableASMService();
    }

    public static MethodVisitor createMethodVisitor(int api) {
        String asmService = ASMFactory.getAsmService();
        if (ASM_SERVICE_ECLIPSELINK.equals(asmService)) {
            return new org.eclipse.persistence.asm.internal.platform.eclipselink.MethodVisitorImpl(api);
        }
        if (ASM_SERVICE_OW2.equals(asmService)) {
            return new MethodVisitorImpl(api);
        }
        throw ValidationException.notAvailableASMService();
    }

    public static MethodVisitor createMethodVisitor(int api, MethodVisitor methodVisitor) {
        String asmService = ASMFactory.getAsmService();
        if (ASM_SERVICE_ECLIPSELINK.equals(asmService)) {
            return new org.eclipse.persistence.asm.internal.platform.eclipselink.MethodVisitorImpl(api, methodVisitor);
        }
        if (ASM_SERVICE_OW2.equals(asmService)) {
            return new MethodVisitorImpl(api, methodVisitor);
        }
        throw ValidationException.notAvailableASMService();
    }

    public static ClassReader createClassReader(InputStream inputStream) throws IOException {
        String asmService = ASMFactory.getAsmService();
        if (ASM_SERVICE_ECLIPSELINK.equals(asmService)) {
            return new ClassReaderImpl(inputStream);
        }
        if (ASM_SERVICE_OW2.equals(asmService)) {
            return new org.eclipse.persistence.asm.internal.platform.ow2.ClassReaderImpl(inputStream);
        }
        throw ValidationException.notAvailableASMService();
    }

    public static ClassReader createClassReader(byte[] classFileBuffer) throws IOException {
        String asmService = ASMFactory.getAsmService();
        if (ASM_SERVICE_ECLIPSELINK.equals(asmService)) {
            return new ClassReaderImpl(classFileBuffer);
        }
        if (ASM_SERVICE_OW2.equals(asmService)) {
            return new org.eclipse.persistence.asm.internal.platform.ow2.ClassReaderImpl(classFileBuffer);
        }
        throw ValidationException.notAvailableASMService();
    }

    public static ClassReader createClassReader(byte[] classFileBuffer, int classFileOffset, int classFileLength) throws IOException {
        String asmService = ASMFactory.getAsmService();
        if (ASM_SERVICE_ECLIPSELINK.equals(asmService)) {
            return new ClassReaderImpl(classFileBuffer, classFileOffset, classFileLength);
        }
        if (ASM_SERVICE_OW2.equals(asmService)) {
            return new org.eclipse.persistence.asm.internal.platform.ow2.ClassReaderImpl(classFileBuffer, classFileOffset, classFileLength);
        }
        throw ValidationException.notAvailableASMService();
    }

    public static ClassReader createClassReader(InputStream inputStream, boolean checkClassVersion) throws IOException {
        String asmService = ASMFactory.getAsmService();
        if (!checkClassVersion || ASM_SERVICE_ECLIPSELINK.equals(asmService)) {
            return new ClassReaderImpl(inputStream, checkClassVersion);
        }
        if (ASM_SERVICE_OW2.equals(asmService)) {
            return new org.eclipse.persistence.asm.internal.platform.ow2.ClassReaderImpl(inputStream);
        }
        throw ValidationException.notAvailableASMService();
    }

    public static ClassWriter createClassWriter() {
        String asmService = ASMFactory.getAsmService();
        if (ASM_SERVICE_ECLIPSELINK.equals(asmService)) {
            return new ClassWriterImpl();
        }
        if (ASM_SERVICE_OW2.equals(asmService)) {
            return new org.eclipse.persistence.asm.internal.platform.ow2.ClassWriterImpl();
        }
        throw ValidationException.notAvailableASMService();
    }

    public static ClassWriter createClassWriter(int flags) {
        String asmService = ASMFactory.getAsmService();
        if (ASM_SERVICE_ECLIPSELINK.equals(asmService)) {
            return new ClassWriterImpl(flags);
        }
        if (ASM_SERVICE_OW2.equals(asmService)) {
            return new org.eclipse.persistence.asm.internal.platform.ow2.ClassWriterImpl(flags);
        }
        throw ValidationException.notAvailableASMService();
    }

    public static ClassWriter createClassWriter(ClassReader classReader, int flags) {
        String asmService = ASMFactory.getAsmService();
        if (ASM_SERVICE_ECLIPSELINK.equals(asmService)) {
            return new ClassWriterImpl(classReader, flags);
        }
        if (ASM_SERVICE_OW2.equals(asmService)) {
            return new org.eclipse.persistence.asm.internal.platform.ow2.ClassWriterImpl(classReader, flags);
        }
        throw ValidationException.notAvailableASMService();
    }

    public static ClassVisitor createClassVisitor(int api) {
        String asmService = ASMFactory.getAsmService();
        if (ASM_SERVICE_ECLIPSELINK.equals(asmService)) {
            return new org.eclipse.persistence.asm.internal.platform.eclipselink.ClassVisitorImpl(api);
        }
        if (ASM_SERVICE_OW2.equals(asmService)) {
            return new ClassVisitorImpl(api);
        }
        throw ValidationException.notAvailableASMService();
    }

    public static ClassVisitor createClassVisitor(int api, ClassVisitor classVisitor) {
        String asmService = ASMFactory.getAsmService();
        if (ASM_SERVICE_ECLIPSELINK.equals(asmService)) {
            return new org.eclipse.persistence.asm.internal.platform.eclipselink.ClassVisitorImpl(api, classVisitor);
        }
        if (ASM_SERVICE_OW2.equals(asmService)) {
            return new ClassVisitorImpl(api, classVisitor);
        }
        throw ValidationException.notAvailableASMService();
    }

    public static Type createType(Class<?> clazz) {
        String asmService = ASMFactory.getAsmService();
        if (ASM_SERVICE_ECLIPSELINK.equals(asmService)) {
            return new org.eclipse.persistence.asm.internal.platform.eclipselink.TypeImpl(clazz);
        }
        if (ASM_SERVICE_OW2.equals(asmService)) {
            return new TypeImpl(clazz);
        }
        throw ValidationException.notAvailableASMService();
    }

    public static Type createType(String typeDescriptor) {
        String asmService = ASMFactory.getAsmService();
        if (ASM_SERVICE_ECLIPSELINK.equals(asmService)) {
            return new org.eclipse.persistence.asm.internal.platform.eclipselink.TypeImpl(typeDescriptor);
        }
        if (ASM_SERVICE_OW2.equals(asmService)) {
            return new TypeImpl(typeDescriptor);
        }
        throw ValidationException.notAvailableASMService();
    }

    public static Type createVoidType() {
        String asmService = ASMFactory.getAsmService();
        if (ASM_SERVICE_ECLIPSELINK.equals(asmService)) {
            return new org.eclipse.persistence.asm.internal.platform.eclipselink.TypeImpl((Class)null);
        }
        if (ASM_SERVICE_OW2.equals(asmService)) {
            return new TypeImpl((Class)null);
        }
        throw ValidationException.notAvailableASMService();
    }

    public static Label createLabel() {
        String asmService = ASMFactory.getAsmService();
        if (ASM_SERVICE_ECLIPSELINK.equals(asmService)) {
            return new org.eclipse.persistence.asm.internal.platform.eclipselink.LabelImpl();
        }
        if (ASM_SERVICE_OW2.equals(asmService)) {
            return new LabelImpl();
        }
        throw ValidationException.notAvailableASMService();
    }

    public static SerialVersionUIDAdder createSerialVersionUIDAdder(ClassVisitor classVisitor) {
        String asmService = ASMFactory.getAsmService();
        if (ASM_SERVICE_ECLIPSELINK.equals(asmService)) {
            return new SerialVersionUIDAdderImpl(classVisitor);
        }
        if (ASM_SERVICE_OW2.equals(asmService)) {
            return new org.eclipse.persistence.asm.internal.platform.ow2.SerialVersionUIDAdderImpl(classVisitor);
        }
        throw ValidationException.notAvailableASMService();
    }

    public static String getAsmService() {
        String asmService = PrivilegedAccessHelper.getSystemProperty("eclipselink.asm.service");
        if (asmService != null) {
            if (ASM_SERVICE_ECLIPSELINK.equals(asmService) && ASMFactory.isASMImplementationAvailable(ASM_ECLIPSELINK_CLASS_VISITOR)) {
                LOG.finest("EclipseLink ASM implementation is used.");
                return asmService;
            }
            if (ASM_SERVICE_OW2.equals(asmService) && ASMFactory.isASMImplementationAvailable(ASM_OW2_CLASS_VISITOR)) {
                LOG.finest("OW2 ASM implementation is used.");
                return asmService;
            }
            throw ValidationException.incorrectASMServiceProvided();
        }
        if (ASMFactory.isASMImplementationAvailable(ASM_ECLIPSELINK_CLASS_VISITOR)) {
            LOG.finest("EclipseLink ASM implementation is used.");
            return ASM_SERVICE_ECLIPSELINK;
        }
        if (ASMFactory.isASMImplementationAvailable(ASM_OW2_CLASS_VISITOR)) {
            LOG.finest("OW2 ASM implementation is used.");
            return ASM_SERVICE_OW2;
        }
        throw ValidationException.notAvailableASMService();
    }

    private static boolean isASMImplementationAvailable(String className) {
        try {
            PrivilegedAccessHelper.getClassForName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static int getLatestOPCodeVersion() {
        String v;
        String latest;
        String oldest;
        LinkedHashMap<String, Integer> versionMap;
        block12: {
            versionMap = new LinkedHashMap<String, Integer>();
            Pattern searchPattern = Pattern.compile("^V\\d((_\\d)?|\\d*)");
            try {
                Class opcodesClazz = Opcodes.getOpcodesClass();
                for (Field f : opcodesClazz.getDeclaredFields()) {
                    if (!searchPattern.matcher(f.getName()).matches()) continue;
                    versionMap.put(f.getName().replace("V", "").replace('_', '.'), f.getInt(opcodesClazz));
                }
            }
            catch (IllegalAccessException ex) {
                LOG.log(7, "Error Java versions map from Opcodes.class fields.", ex);
                throw new RuntimeException(ex);
            }
            ArrayList versions = new ArrayList(versionMap.keySet());
            oldest = (String)versions.get(0);
            latest = (String)versions.get(versions.size() - 1);
            v = oldest;
            if (System.getSecurityManager() == null) {
                v = System.getProperty("java.specification.version");
            } else {
                try {
                    v = AccessController.doPrivileged(new PrivilegedAction<String>(){

                        @Override
                        public String run() {
                            return System.getProperty("java.specification.version");
                        }
                    });
                }
                catch (Throwable t) {
                    LOG.log(6, "Cannot read 'java.specification.version' property.", t);
                    if (!LOG.shouldLog(3)) break block12;
                    LOG.log(3, "Generating bytecode for Java SE ''{0}''.", v);
                }
            }
        }
        Integer version = (Integer)versionMap.get(v);
        if (version == null) {
            if (latest.compareTo(v) < 0) {
                LOG.log(6, "Java SE ''{0}'' is not fully supported yet. Report this error to the EclipseLink open source project.", v);
                if (LOG.shouldLog(3)) {
                    LOG.log(3, "Generating bytecode for Java SE ''{0}''.", latest);
                }
                version = (Integer)versionMap.get(latest);
            } else {
                String key = oldest;
                LOG.log(6, "Java SE ''{0}'' is too old.", v);
                if (LOG.shouldLog(3)) {
                    LOG.log(3, "Generating bytecode for Java SE ''{0}''.", key);
                }
                version = (Integer)versionMap.get(key);
            }
        }
        return version;
    }
}

