/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.compress;

import com.clickhouse.data.ClickHouseCompression;
import com.clickhouse.data.ClickHouseCompressionAlgorithm;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseOutputStream;
import com.clickhouse.data.ClickHousePassThruStream;
import com.clickhouse.data.stream.WrappedInputStream;
import com.clickhouse.data.stream.WrappedOutputStream;
import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdInputStream;
import com.github.luben.zstd.ZstdOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class ZstdSupport {
    public static ClickHouseCompressionAlgorithm getInstance() {
        return Factory.instance;
    }

    private ZstdSupport() {
    }

    static final class Factory {
        private static final ClickHouseCompressionAlgorithm instance = new DefaultImpl();

        private Factory() {
        }
    }

    static class DefaultImpl
    implements ClickHouseCompressionAlgorithm {
        DefaultImpl() {
        }

        protected int normalize(int level) {
            return level < 0 || level > 22 ? Zstd.defaultCompressionLevel() : level;
        }

        @Override
        public ClickHouseOutputStream compress(ClickHousePassThruStream stream, OutputStream output, int bufferSize, int level, Runnable postCloseAction) throws IOException {
            return new WrappedOutputStream(stream, (OutputStream)new ZstdOutputStream(output, this.normalize(level)), bufferSize, postCloseAction);
        }

        @Override
        public ClickHouseInputStream decompress(ClickHousePassThruStream stream, InputStream input, int bufferSize, int level, Runnable postCloseAction) throws IOException {
            return new WrappedInputStream(stream, (InputStream)new ZstdInputStream(input).setContinuous(true), bufferSize, postCloseAction);
        }

        @Override
        public ClickHouseCompression getAlgorithm() {
            return ClickHouseCompression.ZSTD;
        }
    }
}

