/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.provider;

import org.hibernate.query.Query;
import org.hibernate.query.spi.SqmQuery;
import org.springframework.lang.Nullable;

public abstract class HibernateUtils {
    private HibernateUtils() {
    }

    @Nullable
    public static String getHibernateQuery(Object query) {
        try {
            if (query instanceof SqmQuery) {
                SqmQuery sqmQuery = (SqmQuery)query;
                String hql = sqmQuery.getQueryString();
                if (!hql.equals("<criteria>")) {
                    return hql;
                }
                return sqmQuery.getSqmStatement().toHqlString();
            }
        }
        catch (RuntimeException runtimeException) {}
        if (query instanceof Query) {
            Query hibernateQuery = (Query)query;
            return hibernateQuery.getQueryString();
        }
        throw new IllegalArgumentException("Don't know how to extract the query string from " + String.valueOf(query));
    }
}

