/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.dispatch.entrance.processor;

import com.fasterxml.jackson.core.type.TypeReference;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import org.apache.hertzbeat.collector.dispatch.entrance.CollectServer;
import org.apache.hertzbeat.common.entity.message.ClusterMsg;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.hertzbeat.remoting.netty.NettyRemotingProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteCyclicTaskProcessor
implements NettyRemotingProcessor {
    private static final Logger log = LoggerFactory.getLogger(DeleteCyclicTaskProcessor.class);
    private final CollectServer collectServer;

    public DeleteCyclicTaskProcessor(CollectServer collectServer) {
        this.collectServer = collectServer;
    }

    public ClusterMsg.Message handle(ChannelHandlerContext ctx, ClusterMsg.Message message) {
        TypeReference<List<Long>> typeReference = new TypeReference<List<Long>>(){};
        List jobIds = (List)JsonUtil.fromJson((String)message.getMsg().toStringUtf8(), (TypeReference)typeReference);
        if (jobIds == null || jobIds.isEmpty()) {
            log.error("collector receive delete cyclic task job ids is null");
            return null;
        }
        for (Long jobId : jobIds) {
            this.collectServer.getCollectJobService().cancelAsyncCollectJob(jobId);
        }
        return null;
    }
}

