/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.metricsets.jvm;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.apache.iotdb.metrics.utils.SystemMetric;

public class JvmClassLoaderMetrics
implements IMetricSet {
    @Override
    public void bindTo(AbstractMetricService metricService) {
        ClassLoadingMXBean classLoadingBean = ManagementFactory.getClassLoadingMXBean();
        metricService.createAutoGauge(SystemMetric.JVM_CLASSES_LOADED_CLASSES.toString(), MetricLevel.IMPORTANT, classLoadingBean, ClassLoadingMXBean::getLoadedClassCount, new String[0]);
        metricService.createAutoGauge(SystemMetric.JVM_CLASSES_UNLOADED_CLASSES.toString(), MetricLevel.IMPORTANT, classLoadingBean, ClassLoadingMXBean::getUnloadedClassCount, new String[0]);
    }

    @Override
    public void unbindFrom(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.JVM_CLASSES_LOADED_CLASSES.toString(), new String[0]);
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.JVM_CLASSES_UNLOADED_CLASSES.toString(), new String[0]);
    }
}

