/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server;

import com.google.common.collect.Maps;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableNode;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

public class VariableTypeManager {
    private final ConcurrentMap<NodeId, VariableTypeDefinition> typeDefinitions = Maps.newConcurrentMap();

    public void registerVariableType(NodeId typeDefinition, Class<? extends UaVariableNode> nodeClass, VariableNodeConstructor variableNodeConstructor) {
        this.typeDefinitions.put(typeDefinition, new VariableTypeDefinition(nodeClass, variableNodeConstructor));
    }

    public Optional<VariableNodeConstructor> getNodeFactory(NodeId typeDefinition) {
        VariableTypeDefinition def = (VariableTypeDefinition)this.typeDefinitions.get(typeDefinition);
        return Optional.ofNullable(def).map(d -> d.nodeFactory);
    }

    @FunctionalInterface
    public static interface VariableNodeConstructor {
        public UaVariableNode apply(UaNodeContext var1, NodeId var2, QualifiedName var3, LocalizedText var4, LocalizedText var5, UInteger var6, UInteger var7);
    }

    private static class VariableTypeDefinition {
        final Class<? extends UaVariableNode> nodeClass;
        final VariableNodeConstructor nodeFactory;

        private VariableTypeDefinition(Class<? extends UaVariableNode> nodeClass, VariableNodeConstructor nodeFactory) {
            this.nodeClass = nodeClass;
            this.nodeFactory = nodeFactory;
        }
    }
}

