/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.store;

import java.util.HashMap;
import java.util.Map;

public enum ProcedureType {
    ADD_CONFIG_NODE_PROCEDURE(0),
    REMOVE_CONFIG_NODE_PROCEDURE(1),
    REMOVE_DATA_NODE_PROCEDURE(100),
    DELETE_DATABASE_PROCEDURE(200),
    REGION_MIGRATE_PROCEDURE(201),
    CREATE_REGION_GROUPS(202),
    RECONSTRUCT_REGION_PROCEDURE(203),
    ADD_REGION_PEER_PROCEDURE(204),
    REMOVE_REGION_PEER_PROCEDURE(205),
    NOTIFY_REGION_MIGRATION_PROCEDURE(206),
    CREATE_MANY_DATABASES_PROCEDURE(250),
    DELETE_TIMESERIES_PROCEDURE(300),
    CREATE_TRIGGER_PROCEDURE(400),
    DROP_TRIGGER_PROCEDURE(401),
    CREATE_PIPE_PROCEDURE(500),
    START_PIPE_PROCEDURE(501),
    STOP_PIPE_PROCEDURE(502),
    DROP_PIPE_PROCEDURE(503),
    CREATE_CQ_PROCEDURE(600),
    DEACTIVATE_TEMPLATE_PROCEDURE(700),
    UNSET_TEMPLATE_PROCEDURE(701),
    SET_TEMPLATE_PROCEDURE(702),
    CREATE_MODEL_PROCEDURE(800),
    DROP_MODEL_PROCEDURE(801),
    REMOVE_AI_NODE_PROCEDURE(802),
    CREATE_PIPE_PLUGIN_PROCEDURE(900),
    DROP_PIPE_PLUGIN_PROCEDURE(901),
    CREATE_PIPE_PROCEDURE_V2(1000),
    START_PIPE_PROCEDURE_V2(1001),
    STOP_PIPE_PROCEDURE_V2(1002),
    DROP_PIPE_PROCEDURE_V2(1003),
    ALTER_PIPE_PROCEDURE_V2(1004),
    ALTER_PIPE_PROCEDURE_V3(1005),
    PIPE_HANDLE_LEADER_CHANGE_PROCEDURE(1100),
    PIPE_META_SYNC_PROCEDURE(1101),
    PIPE_HANDLE_META_CHANGE_PROCEDURE(1102),
    DELETE_LOGICAL_VIEW_PROCEDURE(1200),
    ALTER_LOGICAL_VIEW_PROCEDURE(1201),
    AUTH_OPERATE_PROCEDURE(1300),
    SET_TTL_PROCEDURE(1400),
    PIPE_ENRICHED_DELETE_DATABASE_PROCEDURE(1401),
    PIPE_ENRICHED_DELETE_TIMESERIES_PROCEDURE(1402),
    PIPE_ENRICHED_DEACTIVATE_TEMPLATE_PROCEDURE(1403),
    PIPE_ENRICHED_UNSET_TEMPLATE_PROCEDURE(1404),
    PIPE_ENRICHED_SET_TEMPLATE_PROCEDURE(1405),
    PIPE_ENRICHED_ALTER_LOGICAL_VIEW_PROCEDURE(1406),
    PIPE_ENRICHED_DELETE_LOGICAL_VIEW_PROCEDURE(1407),
    PIPE_ENRICHED_CREATE_TRIGGER_PROCEDURE(1408),
    PIPE_ENRICHED_DROP_TRIGGER_PROCEDURE(1409),
    PIPE_ENRICHED_AUTH_OPERATE_PROCEDURE(1410),
    PIPE_ENRICHED_SET_TTL_PROCEDURE(1411),
    CREATE_TOPIC_PROCEDURE(1500),
    DROP_TOPIC_PROCEDURE(1501),
    ALTER_TOPIC_PROCEDURE(1502),
    CREATE_SUBSCRIPTION_PROCEDURE(1503),
    DROP_SUBSCRIPTION_PROCEDURE(1504),
    CREATE_CONSUMER_PROCEDURE(1505),
    DROP_CONSUMER_PROCEDURE(1506),
    ALTER_CONSUMER_GROUP_PROCEDURE(1507),
    TOPIC_META_SYNC_PROCEDURE(1508),
    CONSUMER_GROUP_META_SYNC_PROCEDURE(1509),
    NEVER_FINISH_PROCEDURE(30000),
    ADD_NEVER_FINISH_SUB_PROCEDURE_PROCEDURE(30001);

    private final short typeCode;
    private static final Map<Short, ProcedureType> TYPE_CODE_MAP;

    private ProcedureType(short typeCode) {
        this.typeCode = typeCode;
    }

    public short getTypeCode() {
        return this.typeCode;
    }

    public static ProcedureType convertToProcedureType(short typeCode) {
        return TYPE_CODE_MAP.getOrDefault(typeCode, null);
    }

    static {
        TYPE_CODE_MAP = new HashMap<Short, ProcedureType>();
        for (ProcedureType procedureType : ProcedureType.values()) {
            TYPE_CODE_MAP.put(procedureType.getTypeCode(), procedureType);
        }
    }
}

