/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.payload.legacy;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.iotdb.db.pipe.connector.payload.legacy.PipeData;
import org.apache.iotdb.db.pipe.receiver.protocol.legacy.loader.ILoader;
import org.apache.iotdb.db.pipe.receiver.protocol.legacy.loader.TsFileLoader;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class TsFilePipeData
extends PipeData {
    private String parentDirPath;
    private String tsFileName;
    private String database;

    public TsFilePipeData() {
    }

    public TsFilePipeData(String parentDirPath, String tsFileName, long serialNumber) {
        super(serialNumber);
        this.parentDirPath = parentDirPath;
        this.tsFileName = tsFileName;
        this.initDatabaseName();
    }

    private void initDatabaseName() {
        if (this.tsFileName == null) {
            this.database = null;
            return;
        }
        String[] parts = this.tsFileName.trim().split("-");
        if (parts.length < 8) {
            this.database = null;
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(parts[1]);
        for (int i = 2; i < parts.length - 6; ++i) {
            stringBuilder.append("-").append(parts[i]);
        }
        this.database = stringBuilder.toString();
    }

    public void setParentDirPath(String parentDirPath) {
        this.parentDirPath = parentDirPath;
    }

    public String getTsFileName() {
        return this.tsFileName;
    }

    public String getTsFilePath() {
        return this.parentDirPath + File.separator + this.tsFileName;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getDatabase() {
        return this.database;
    }

    @Override
    public PipeData.PipeDataType getPipeDataType() {
        return PipeData.PipeDataType.TSFILE;
    }

    @Override
    public long serialize(DataOutputStream stream) throws IOException {
        return super.serialize(stream) + (long)ReadWriteIOUtils.write((String)this.parentDirPath, (OutputStream)stream) + (long)ReadWriteIOUtils.write((String)this.tsFileName, (OutputStream)stream);
    }

    @Override
    public void deserialize(DataInputStream stream) throws IOException {
        super.deserialize(stream);
        this.parentDirPath = ReadWriteIOUtils.readString((InputStream)stream);
        if (this.parentDirPath == null) {
            this.parentDirPath = "";
        }
        this.tsFileName = ReadWriteIOUtils.readString((InputStream)stream);
        this.initDatabaseName();
    }

    @Override
    public ILoader createLoader() {
        return new TsFileLoader(new File(this.getTsFilePath()), this.database);
    }

    public String toString() {
        return "TsFilePipeData{serialNumber=" + this.serialNumber + ", tsFilePath='" + this.getTsFilePath() + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TsFilePipeData pipeData = (TsFilePipeData)o;
        return Objects.equals(this.parentDirPath, pipeData.parentDirPath) && Objects.equals(this.tsFileName, pipeData.tsFileName) && Objects.equals(this.serialNumber, pipeData.serialNumber);
    }

    public int hashCode() {
        return Objects.hash(this.parentDirPath, this.tsFileName, this.serialNumber);
    }
}

