/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.filter.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.commons.schema.filter.SchemaFilterType;
import org.apache.iotdb.commons.schema.filter.SchemaFilterVisitor;

public class AndFilter
extends SchemaFilter {
    private final SchemaFilter left;
    private final SchemaFilter right;

    public AndFilter(SchemaFilter left, SchemaFilter right) {
        this.left = left;
        this.right = right;
    }

    public AndFilter(ByteBuffer byteBuffer) {
        this.left = SchemaFilter.deserialize(byteBuffer);
        this.right = SchemaFilter.deserialize(byteBuffer);
    }

    public SchemaFilter getLeft() {
        return this.left;
    }

    public SchemaFilter getRight() {
        return this.right;
    }

    @Override
    public <C> boolean accept(SchemaFilterVisitor<C> visitor, C node) {
        return visitor.visitAndFilter(this, node);
    }

    @Override
    public SchemaFilterType getSchemaFilterType() {
        return SchemaFilterType.AND;
    }

    @Override
    public void serialize(ByteBuffer byteBuffer) {
        this.left.serialize(byteBuffer);
        this.right.serialize(byteBuffer);
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        this.left.serialize(stream);
        this.right.serialize(stream);
    }
}

