/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.pipe;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;

public class PipeEnrichedStatement
extends Statement {
    private Statement innerStatement;

    public PipeEnrichedStatement(Statement innerStatement) {
        this.statementType = StatementType.PIPE_ENRICHED;
        this.innerStatement = innerStatement;
    }

    public Statement getInnerStatement() {
        return this.innerStatement;
    }

    public void setInnerStatement(Statement innerStatement) {
        this.innerStatement = innerStatement;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitPipeEnrichedStatement(this, context);
    }

    @Override
    public boolean isDebug() {
        return this.innerStatement.isDebug();
    }

    @Override
    public void setDebug(boolean debug) {
        this.innerStatement.setDebug(debug);
    }

    @Override
    public boolean isQuery() {
        return !Objects.isNull(this.innerStatement) && this.innerStatement.isQuery();
    }

    @Override
    public List<PartialPath> getPaths() {
        return Collections.emptyList();
    }
}

