/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.source.schemaregion;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TablePattern;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.RelationalDeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.CreateOrUpdateTableDeviceNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.TableDeviceAttributeUpdateNode;
import org.apache.iotdb.db.storageengine.dataregion.modification.TableDeletionEntry;

public class PipePlanTablePatternParseVisitor
extends PlanVisitor<Optional<PlanNode>, TablePattern> {
    @Override
    public Optional<PlanNode> visitPlan(PlanNode node, TablePattern pattern) {
        return Optional.of(node);
    }

    @Override
    public Optional<PlanNode> visitCreateOrUpdateTableDevice(CreateOrUpdateTableDeviceNode node, TablePattern pattern) {
        return pattern.matchesDatabase(node.getDatabase()) && pattern.matchesTable(node.getTableName()) ? Optional.of(node) : Optional.empty();
    }

    @Override
    public Optional<PlanNode> visitTableDeviceAttributeUpdate(TableDeviceAttributeUpdateNode node, TablePattern pattern) {
        return pattern.matchesDatabase(node.getDatabase()) && pattern.matchesTable(node.getTableName()) ? Optional.of(node) : Optional.empty();
    }

    @Override
    public Optional<PlanNode> visitDeleteData(RelationalDeleteDataNode node, TablePattern pattern) {
        if (Objects.isNull(node.getDatabaseName()) || !pattern.matchesDatabase(node.getDatabaseName())) {
            return Optional.empty();
        }
        List<TableDeletionEntry> deletionEntries = node.getModEntries().stream().filter(entry -> pattern.matchesTable(entry.getTableName())).collect(Collectors.toList());
        return !deletionEntries.isEmpty() ? Optional.of(new RelationalDeleteDataNode(node.getPlanNodeId(), deletionEntries, node.getDatabaseName())) : Optional.empty();
    }
}

