/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.common.schematree;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.common.schematree.IMeasurementSchemaInfo;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class DeviceSchemaInfo {
    private PartialPath devicePath;
    private boolean isAligned;
    private List<IMeasurementSchemaInfo> measurementSchemaInfoList;
    private int templateId = -1;

    private DeviceSchemaInfo() {
    }

    public DeviceSchemaInfo(PartialPath devicePath, boolean isAligned, int templateId, List<IMeasurementSchemaInfo> measurementSchemaInfoList) {
        this.devicePath = devicePath;
        this.isAligned = isAligned;
        this.templateId = templateId;
        this.measurementSchemaInfoList = measurementSchemaInfoList;
    }

    public PartialPath getDevicePath() {
        return this.devicePath;
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    public int getTemplateId() {
        return this.templateId;
    }

    public List<IMeasurementSchema> getMeasurementSchemaList() {
        return this.measurementSchemaInfoList.stream().map(measurementSchemaInfo -> measurementSchemaInfo == null ? null : measurementSchemaInfo.getSchemaAsMeasurementSchema()).collect(Collectors.toList());
    }

    public List<IMeasurementSchemaInfo> getMeasurementSchemaInfoList() {
        return this.measurementSchemaInfoList;
    }

    public List<MeasurementPath> getMeasurementSchemaPathList() {
        return this.measurementSchemaInfoList.stream().map(measurementSchemaInfo -> {
            if (measurementSchemaInfo == null) {
                return null;
            }
            MeasurementPath measurementPath = new MeasurementPath(this.devicePath.concatNode(measurementSchemaInfo.getName()), measurementSchemaInfo.getSchema());
            if (measurementSchemaInfo.getAlias() != null) {
                measurementPath.setMeasurementAlias(measurementSchemaInfo.getAlias());
            }
            if (measurementSchemaInfo.getTagMap() != null) {
                measurementPath.setTagMap(measurementSchemaInfo.getTagMap());
            }
            measurementPath.setUnderAlignedEntity(Boolean.valueOf(this.isAligned));
            return measurementPath;
        }).collect(Collectors.toList());
    }

    public List<MeasurementPath> getMeasurements(Set<String> measurements) {
        if (measurements.contains("*")) {
            return this.measurementSchemaInfoList.stream().map(measurementInfo -> {
                if (measurementInfo == null) {
                    return null;
                }
                MeasurementPath measurementPath = new MeasurementPath(this.devicePath.concatNode(measurementInfo.getName()), measurementInfo.getSchema());
                if (measurementInfo.getAlias() != null) {
                    measurementPath.setMeasurementAlias(measurementInfo.getAlias());
                }
                measurementPath.setUnderAlignedEntity(Boolean.valueOf(this.isAligned));
                return measurementPath;
            }).collect(Collectors.toList());
        }
        ArrayList<MeasurementPath> measurementPaths = new ArrayList<MeasurementPath>();
        for (IMeasurementSchemaInfo measurementSchemaInfo : this.measurementSchemaInfoList) {
            MeasurementPath measurementPath = new MeasurementPath(this.devicePath.concatNode(measurementSchemaInfo.getName()), measurementSchemaInfo.getSchema());
            measurementPath.setUnderAlignedEntity(Boolean.valueOf(this.isAligned));
            if (measurements.contains(measurementSchemaInfo.getName())) {
                measurementPaths.add(measurementPath);
                continue;
            }
            if (measurementSchemaInfo.getAlias() == null || !measurements.contains(measurementSchemaInfo.getAlias())) continue;
            measurementPath.setMeasurementAlias(measurementSchemaInfo.getAlias());
            measurementPaths.add(measurementPath);
        }
        return measurementPaths;
    }
}

