/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.window;

import org.apache.iotdb.db.queryengine.execution.operator.window.EqualIntWindow;
import org.apache.iotdb.db.queryengine.execution.operator.window.VariationWindowManager;
import org.apache.iotdb.db.queryengine.execution.operator.window.VariationWindowParameter;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.block.TsBlock;

public class EqualIntWindowManager
extends VariationWindowManager {
    public EqualIntWindowManager(VariationWindowParameter variationWindowParameter, boolean ascending) {
        super(ascending);
        this.variationWindow = new EqualIntWindow(variationWindowParameter);
    }

    @Override
    public TsBlock skipPointsOutOfCurWindow(TsBlock inputTsBlock) {
        int i;
        if (!this.needSkip) {
            return inputTsBlock;
        }
        if (inputTsBlock == null || inputTsBlock.isEmpty()) {
            return inputTsBlock;
        }
        Column controlColumn = this.variationWindow.getControlColumn(inputTsBlock);
        Column timeColumn = inputTsBlock.getTimeColumn();
        int size = inputTsBlock.getPositionCount();
        int previousValue = ((EqualIntWindow)this.variationWindow).getPreviousHeadValue();
        boolean previousValueIsNull = ((EqualIntWindow)this.variationWindow).valueIsNull();
        for (i = 0; i < size; ++i) {
            boolean condition = false;
            boolean isNull = controlColumn.isNull(i);
            if (!isNull) {
                boolean bl = condition = controlColumn.getInt(i) != previousValue;
            }
            if (this.isIgnoringNull()) {
                if (!isNull && condition) break;
                if (isNull) {
                    continue;
                }
            } else if (isNull && !previousValueIsNull || !isNull && previousValueIsNull || !isNull && condition) break;
            long currentTime = timeColumn.getLong(i);
            if (this.variationWindow.getStartTime() > currentTime) {
                this.variationWindow.setStartTime(currentTime);
            }
            if (this.variationWindow.getEndTime() >= currentTime) continue;
            this.variationWindow.setEndTime(currentTime);
        }
        if (i < size) {
            this.needSkip = false;
        }
        return inputTsBlock.subTsBlock(i);
    }
}

