/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.ternary;

import org.apache.iotdb.db.queryengine.plan.expression.unary.LikeExpression;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.TableMetadataImpl;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ternary.TernaryColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.common.regexp.LikePattern;
import org.apache.tsfile.read.common.type.Type;

public class Like3ColumnTransformer
extends TernaryColumnTransformer {
    public Like3ColumnTransformer(Type retuenType, ColumnTransformer firstColumnTransformer, ColumnTransformer secondColumnTransformer, ColumnTransformer thirdColumnTransformer) {
        super(retuenType, firstColumnTransformer, secondColumnTransformer, thirdColumnTransformer);
    }

    @Override
    protected void checkType() {
        if (!TableMetadataImpl.isCharType(this.firstColumnTransformer.getType())) {
            throw new UnsupportedOperationException("Unsupported Type: " + this.firstColumnTransformer.getType().getTypeEnum());
        }
        if (!TableMetadataImpl.isCharType(this.secondColumnTransformer.getType())) {
            throw new UnsupportedOperationException("Unsupported Type: " + this.secondColumnTransformer.getType().getTypeEnum());
        }
        if (!TableMetadataImpl.isCharType(this.thirdColumnTransformer.getType())) {
            throw new UnsupportedOperationException("Unsupported Type: " + this.thirdColumnTransformer.getType().getTypeEnum());
        }
    }

    @Override
    protected void doTransform(Column firstColumn, Column secondColumn, Column thirdColumn, ColumnBuilder builder, int positionCount) {
        for (int i = 0; i < positionCount; ++i) {
            this.transform(firstColumn, secondColumn, thirdColumn, builder, i);
        }
    }

    @Override
    protected void doTransform(Column firstColumn, Column secondColumn, Column thirdColumn, ColumnBuilder builder, int positionCount, boolean[] selection) {
        for (int i = 0; i < positionCount; ++i) {
            if (selection[i]) {
                this.transform(firstColumn, secondColumn, thirdColumn, builder, i);
                continue;
            }
            builder.appendNull();
        }
    }

    private void transform(Column firstColumn, Column secondColumn, Column thirdColumn, ColumnBuilder builder, int i) {
        if (!(firstColumn.isNull(i) || secondColumn.isNull(i) || thirdColumn.isNull(i))) {
            LikePattern pattern = LikePattern.compile((String)secondColumn.getBinary(i).getStringValue(TSFileConfig.STRING_CHARSET), LikeExpression.getEscapeCharacter(thirdColumn.getBinary(i).getStringValue(TSFileConfig.STRING_CHARSET)), (boolean)false);
            builder.writeBoolean(pattern.getMatcher().match(firstColumn.getBinary(i).getValues(), 0, firstColumn.getBinary(i).getLength()));
        } else {
            builder.appendNull();
        }
    }
}

