/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.sink.util.sorter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.pipe.sink.util.sorter.PipeTabletEventSorter;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.record.Tablet;

public class PipeTableModelTabletEventSorter
extends PipeTabletEventSorter {
    private int initIndexSize;

    public PipeTableModelTabletEventSorter(Tablet tablet) {
        super(tablet);
        this.deDuplicatedSize = tablet == null ? 0 : tablet.getRowSize();
    }

    public void sortAndDeduplicateByDevIdTimestamp() {
        if (this.tablet == null || this.tablet.getRowSize() < 1) {
            return;
        }
        HashMap<IDeviceID, List> deviceIDToIndexMap = new HashMap<IDeviceID, List>();
        long[] timestamps = this.tablet.getTimestamps();
        IDeviceID lastDevice = this.tablet.getDeviceID(0);
        long previousTimestamp = this.tablet.getTimestamp(0);
        int lasIndex = 0;
        int size = this.tablet.getRowSize();
        for (int i = 1; i < size; ++i) {
            List list;
            IDeviceID deviceID = this.tablet.getDeviceID(i);
            long currentTimestamp = timestamps[i];
            int deviceComparison = deviceID.compareTo((Object)lastDevice);
            if (deviceComparison == 0) {
                if (previousTimestamp == currentTimestamp) {
                    this.isDeDuplicated = false;
                    continue;
                }
                if (previousTimestamp > currentTimestamp) {
                    this.isSorted = false;
                }
                previousTimestamp = currentTimestamp;
                continue;
            }
            if (deviceComparison < 0) {
                this.isSorted = false;
            }
            if (!(list = deviceIDToIndexMap.computeIfAbsent(lastDevice, k -> new ArrayList())).isEmpty()) {
                this.isSorted = false;
            }
            list.add(new Pair((Object)lasIndex, (Object)i));
            lastDevice = deviceID;
            lasIndex = i;
            previousTimestamp = currentTimestamp;
        }
        List list = deviceIDToIndexMap.computeIfAbsent(lastDevice, k -> new ArrayList());
        if (!list.isEmpty()) {
            this.isSorted = false;
        }
        list.add(new Pair((Object)lasIndex, (Object)this.tablet.getRowSize()));
        if (this.isSorted && this.isDeDuplicated) {
            return;
        }
        this.initIndexSize = 0;
        this.deDuplicatedSize = 0;
        this.index = new Integer[this.tablet.getRowSize()];
        this.deDuplicatedIndex = new int[this.tablet.getRowSize()];
        deviceIDToIndexMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            int i = this.initIndexSize;
            for (Pair pair : (List)entry.getValue()) {
                for (int j = ((Integer)pair.left).intValue(); j < (Integer)pair.right; ++j) {
                    this.index[i++] = j;
                }
            }
            if (!this.isSorted) {
                this.sortTimestamps(this.initIndexSize, i);
                this.deDuplicateTimestamps(this.initIndexSize, i);
                this.initIndexSize = i;
                return;
            }
            if (!this.isDeDuplicated) {
                this.deDuplicateTimestamps(this.initIndexSize, i);
            }
            this.initIndexSize = i;
        });
        this.sortAndDeduplicateValuesAndBitMapsWithTimestamp();
    }

    private void sortAndDeduplicateValuesAndBitMapsWithTimestamp() {
        this.tablet.setTimestamps((long[])this.reorderValueListAndBitMap(this.tablet.getTimestamps(), TSDataType.TIMESTAMP, null, null));
        this.sortAndMayDeduplicateValuesAndBitMaps();
        this.tablet.setRowSize(this.deDuplicatedSize);
    }

    private void sortTimestamps(int startIndex, int endIndex) {
        Arrays.sort(this.index, startIndex, endIndex, Comparator.comparingLong(arg_0 -> ((Tablet)this.tablet).getTimestamp(arg_0)));
    }

    private void deDuplicateTimestamps(int startIndex, int endIndex) {
        long[] timestamps = this.tablet.getTimestamps();
        long lastTime = timestamps[this.index[startIndex]];
        for (int i = startIndex + 1; i < endIndex; ++i) {
            if (lastTime == (lastTime = timestamps[this.index[i]])) continue;
            this.deDuplicatedIndex[this.deDuplicatedSize++] = i - 1;
        }
        this.deDuplicatedIndex[this.deDuplicatedSize++] = endIndex - 1;
    }

    public void sortByTimestampIfNecessary() {
        int i;
        if (this.tablet == null || this.tablet.getRowSize() == 0) {
            return;
        }
        long[] timestamps = this.tablet.getTimestamps();
        int size = this.tablet.getRowSize();
        for (i = 1; i < size; ++i) {
            long currentTimestamp = timestamps[i];
            long previousTimestamp = timestamps[i - 1];
            if (currentTimestamp >= previousTimestamp) continue;
            this.isSorted = false;
            break;
        }
        if (this.isSorted) {
            return;
        }
        this.index = new Integer[this.tablet.getRowSize()];
        size = this.tablet.getRowSize();
        for (i = 0; i < size; ++i) {
            this.index[i] = i;
        }
        if (!this.isSorted) {
            this.sortTimestamps();
        }
        this.sortAndMayDeduplicateValuesAndBitMaps();
    }

    private void sortTimestamps() {
        Arrays.sort(this.index, Comparator.comparingLong(arg_0 -> ((Tablet)this.tablet).getTimestamp(arg_0)));
        Arrays.sort(this.tablet.getTimestamps(), 0, this.tablet.getRowSize());
    }
}

