/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.common;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.db.protocol.session.IClientSession;
import org.apache.iotdb.db.queryengine.plan.relational.security.Identity;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class SessionInfo {
    private final long sessionId;
    private final String userName;
    private final ZoneId zoneId;
    @Nullable
    private final String databaseName;
    private final IClientSession.SqlDialect sqlDialect;
    private IoTDBConstant.ClientVersion version = IoTDBConstant.ClientVersion.V_1_0;

    public SessionInfo(long sessionId, String userName, ZoneId zoneId) {
        this.sessionId = sessionId;
        this.userName = userName;
        this.zoneId = zoneId;
        this.databaseName = null;
        this.sqlDialect = IClientSession.SqlDialect.TREE;
    }

    public SessionInfo(long sessionId, String userName, ZoneId zoneId, @Nullable String databaseName, IClientSession.SqlDialect sqlDialect) {
        this(sessionId, userName, zoneId, IoTDBConstant.ClientVersion.V_1_0, databaseName, sqlDialect);
    }

    public SessionInfo(long sessionId, String userName, ZoneId zoneId, IoTDBConstant.ClientVersion version, @Nullable String databaseName, IClientSession.SqlDialect sqlDialect) {
        this.sessionId = sessionId;
        this.userName = userName;
        this.zoneId = zoneId;
        this.version = version;
        this.databaseName = databaseName;
        this.sqlDialect = sqlDialect;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public String getUserName() {
        return this.userName;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public IoTDBConstant.ClientVersion getVersion() {
        return this.version;
    }

    public Identity getIdentity() {
        return new Identity(this.userName);
    }

    public Optional<String> getDatabaseName() {
        return Optional.ofNullable(this.databaseName);
    }

    public IClientSession.SqlDialect getSqlDialect() {
        return this.sqlDialect;
    }

    public static SessionInfo deserializeFrom(ByteBuffer buffer) {
        long sessionId = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
        String userName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        ZoneId zoneId = ZoneId.of(Objects.requireNonNull(ReadWriteIOUtils.readString((ByteBuffer)buffer)));
        boolean hasDatabaseName = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        String databaseName = null;
        if (hasDatabaseName) {
            databaseName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        }
        IClientSession.SqlDialect sqlDialect1 = IClientSession.SqlDialect.deserializeFrom(buffer);
        return new SessionInfo(sessionId, userName, zoneId, databaseName, sqlDialect1);
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((long)this.sessionId, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.userName, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.zoneId.getId(), (OutputStream)stream);
        if (this.databaseName == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            ReadWriteIOUtils.write((String)this.databaseName, (OutputStream)stream);
        }
        this.sqlDialect.serialize(stream);
    }

    public void serialize(ByteBuffer buffer) {
        ReadWriteIOUtils.write((long)this.sessionId, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((String)this.userName, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((String)this.zoneId.getId(), (ByteBuffer)buffer);
        if (this.databaseName == null) {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)buffer);
        } else {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)buffer);
            ReadWriteIOUtils.write((String)this.databaseName, (ByteBuffer)buffer);
        }
        this.sqlDialect.serialize(buffer);
    }
}

