/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.fill.constant;

import java.util.Optional;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.IFill;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.block.column.BooleanColumn;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;

public class BooleanConstantFill
implements IFill {
    private final boolean value;
    private final boolean[] valueArray;

    public BooleanConstantFill(boolean value) {
        this.value = value;
        this.valueArray = new boolean[]{value};
    }

    @Override
    public Column fill(Column timeColumn, Column valueColumn) {
        int size = valueColumn.getPositionCount();
        if (!valueColumn.mayHaveNull() || size == 0) {
            return valueColumn;
        }
        if (valueColumn instanceof RunLengthEncodedColumn) {
            return new RunLengthEncodedColumn((Column)new BooleanColumn(1, Optional.empty(), this.valueArray), size);
        }
        boolean[] array = new boolean[size];
        for (int i = 0; i < size; ++i) {
            array[i] = valueColumn.isNull(i) ? this.value : valueColumn.getBoolean(i);
        }
        return new BooleanColumn(size, Optional.empty(), array);
    }

    @Override
    public void reset() {
    }
}

