/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.window.function.aggregate;

import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.Partition;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.TableScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.AggregationMask;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.TableAccumulator;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;

public class WindowAggregator {
    private final TableAccumulator accumulator;
    private final TSDataType outputType;
    private final int[] inputChannels;

    public WindowAggregator(TableAccumulator accumulator, TSDataType outputType, List<Integer> inputChannels) {
        this.accumulator = Objects.requireNonNull(accumulator, "accumulator is null");
        this.outputType = Objects.requireNonNull(outputType, "intermediateType is null");
        this.inputChannels = Ints.toArray((Collection)Objects.requireNonNull(inputChannels, "inputChannels is null"));
    }

    public TSDataType getType() {
        return this.outputType;
    }

    public void addInput(Partition partition) {
        List<Column[]> allColumns = partition.getAllColumns();
        for (Column[] columns : allColumns) {
            this.addInput(columns);
        }
    }

    public void addInput(Column[] columns) {
        Column[] arguments = new Column[this.inputChannels.length];
        for (int i = 0; i < this.inputChannels.length; ++i) {
            arguments[i] = columns[this.inputChannels[i]];
        }
        int count = columns[0].getPositionCount();
        if (arguments.length == 0) {
            arguments = new Column[]{new RunLengthEncodedColumn((Column)TableScanOperator.TIME_COLUMN_TEMPLATE, count)};
        }
        AggregationMask mask = AggregationMask.createSelectAll(count);
        this.accumulator.addInput(arguments, mask);
    }

    public void removeInput(Partition partition) {
        List<Column[]> allColumns = partition.getAllColumns();
        for (Column[] columns : allColumns) {
            this.removeInput(columns);
        }
    }

    private void removeInput(Column[] columns) {
        Column[] arguments = new Column[this.inputChannels.length];
        for (int i = 0; i < this.inputChannels.length; ++i) {
            arguments[i] = columns[this.inputChannels[i]];
        }
        int count = columns[0].getPositionCount();
        if (arguments.length == 0) {
            arguments = new Column[]{new RunLengthEncodedColumn((Column)TableScanOperator.TIME_COLUMN_TEMPLATE, count)};
        }
        this.accumulator.removeInput(arguments);
    }

    public void evaluate(ColumnBuilder columnBuilder) {
        this.accumulator.evaluateFinal(columnBuilder);
    }

    public void processStatistics(Statistics[] statistics) {
        this.accumulator.addStatistics(statistics);
    }

    public boolean hasFinalResult() {
        return this.accumulator.hasFinalResult();
    }

    public void reset() {
        this.accumulator.reset();
    }

    public boolean removable() {
        return this.accumulator.removable();
    }

    public long getEstimatedSize() {
        return this.accumulator.getEstimatedSize();
    }

    public int getChannelCount() {
        return this.inputChannels.length;
    }
}

