/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.crud;

import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.iotdb.commons.utils.TimePartitionUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.DataTypeMismatchException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.pipe.resource.memory.InsertNodeMemoryEstimator;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.schematree.IMeasurementSchemaInfo;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaValidation;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ColumnSchema;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InsertRow;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.db.utils.CommonUtils;
import org.apache.iotdb.db.utils.TypeInferenceUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.annotations.TableModel;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertRowStatement
extends InsertBaseStatement
implements ISchemaValidation {
    private static final Logger LOGGER = LoggerFactory.getLogger(InsertRowStatement.class);
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(InsertRowStatement.class);
    protected static final byte TYPE_RAW_STRING = -1;
    protected static final byte TYPE_NULL = -2;
    protected long time;
    protected Object[] values;
    protected boolean isNeedInferType = false;
    protected boolean[] measurementIsAligned;
    protected IDeviceID deviceID;

    public InsertRowStatement() {
        this.statementType = StatementType.INSERT;
        this.recordedBeginOfLogicalViewSchemaList = 0;
        this.recordedEndOfLogicalViewSchemaList = 0;
    }

    @Override
    public List<PartialPath> getPaths() {
        ArrayList<PartialPath> ret = new ArrayList<PartialPath>();
        for (String m : this.measurements) {
            MeasurementPath fullPath = this.devicePath.concatAsMeasurementPath(m);
            ret.add((PartialPath)fullPath);
        }
        return ret;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public Object[] getValues() {
        return this.values;
    }

    public void setValues(Object[] values) {
        this.values = values;
    }

    public boolean isNeedInferType() {
        return this.isNeedInferType;
    }

    public void setNeedInferType(boolean needInferType) {
        this.isNeedInferType = needInferType;
    }

    @Override
    public boolean isEmpty() {
        return this.values.length == 0;
    }

    public void fillValues(ByteBuffer buffer) throws QueryProcessException {
        this.values = new Object[this.measurements.length];
        this.dataTypes = new TSDataType[this.measurements.length];
        block8: for (int i = 0; i < this.dataTypes.length; ++i) {
            byte typeNum = (byte)ReadWriteIOUtils.read((ByteBuffer)buffer);
            if (typeNum == -1 || typeNum == -2) {
                this.values[i] = typeNum == -1 ? ReadWriteIOUtils.readString((ByteBuffer)buffer) : null;
                continue;
            }
            this.dataTypes[i] = TSDataType.values()[typeNum];
            switch (this.dataTypes[i]) {
                case BOOLEAN: {
                    this.values[i] = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
                    continue block8;
                }
                case INT32: 
                case DATE: {
                    this.values[i] = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
                    continue block8;
                }
                case INT64: 
                case TIMESTAMP: {
                    this.values[i] = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
                    continue block8;
                }
                case FLOAT: {
                    this.values[i] = Float.valueOf(ReadWriteIOUtils.readFloat((ByteBuffer)buffer));
                    continue block8;
                }
                case DOUBLE: {
                    this.values[i] = ReadWriteIOUtils.readDouble((ByteBuffer)buffer);
                    continue block8;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    this.values[i] = ReadWriteIOUtils.readBinary((ByteBuffer)buffer);
                    continue block8;
                }
                default: {
                    throw new QueryProcessException("Unsupported data type:" + this.dataTypes[i]);
                }
            }
        }
    }

    public TTimePartitionSlot getTimePartitionSlot() {
        return TimePartitionUtils.getTimePartitionSlot((long)this.time);
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitInsertRow(this, context);
    }

    @Override
    public long getMinTime() {
        return this.getTime();
    }

    @Override
    public Object getFirstValueOfIndex(int index) {
        return this.values[index];
    }

    @Override
    protected boolean checkAndCastDataType(int columnIndex, TSDataType dataType) {
        if (dataType.isCompatible(this.dataTypes[columnIndex])) {
            this.values[columnIndex] = dataType.castFromSingleValue(this.dataTypes[columnIndex], this.values[columnIndex]);
            this.dataTypes[columnIndex] = dataType;
            return true;
        }
        return false;
    }

    public void transferType(ZoneId zoneId) throws QueryProcessException {
        for (int i = 0; i < this.measurementSchemas.length; ++i) {
            if (this.measurementSchemas[i] == null) {
                if (!IoTDBDescriptor.getInstance().getConfig().isEnablePartialInsert()) {
                    throw new QueryProcessException((IoTDBException)((Object)new PathNotExistException(this.devicePath.getFullPath() + '.' + this.measurements[i])));
                }
                this.markFailedMeasurement(i, (Exception)((Object)new QueryProcessException((IoTDBException)((Object)new PathNotExistException(this.devicePath.getFullPath() + '.' + this.measurements[i])))));
                continue;
            }
            this.dataTypes[i] = this.measurementSchemas[i].getType();
            try {
                if (this.values[i] == null || this.dataTypes[i].isBinary() && this.values[i] instanceof Binary) continue;
                this.values[i] = CommonUtils.parseValue(this.dataTypes[i], this.values[i].toString(), zoneId);
                continue;
            }
            catch (Exception e) {
                LOGGER.warn("data type of {}.{} is not consistent, registered type {}, inserting timestamp {}, value {}", new Object[]{this.devicePath, this.measurements[i], this.dataTypes[i], this.time, this.values[i]});
                if (!IoTDBDescriptor.getInstance().getConfig().isEnablePartialInsert()) {
                    throw e;
                }
                this.markFailedMeasurement(i, (Exception)((Object)new SemanticException(e, TSStatusCode.DATA_TYPE_MISMATCH.getStatusCode())));
            }
        }
        this.isNeedInferType = false;
    }

    @Override
    public void markFailedMeasurement(int index, Exception cause) {
        if (this.measurements[index] == null) {
            return;
        }
        if (this.failedMeasurementIndex2Info == null) {
            this.failedMeasurementIndex2Info = new HashMap();
        }
        InsertBaseStatement.FailedMeasurementInfo failedMeasurementInfo = new InsertBaseStatement.FailedMeasurementInfo(this.measurements[index], this.dataTypes[index], this.values[index], cause);
        this.failedMeasurementIndex2Info.putIfAbsent(index, failedMeasurementInfo);
        this.measurements[index] = null;
        this.dataTypes[index] = null;
        this.values[index] = null;
    }

    @Override
    public void removeAllFailedMeasurementMarks() {
        if (this.failedMeasurementIndex2Info == null) {
            return;
        }
        this.failedMeasurementIndex2Info.forEach((index, info) -> {
            if (this.measurements != null) {
                this.measurements[index.intValue()] = info.getMeasurement();
            }
            if (this.dataTypes != null) {
                this.dataTypes[index.intValue()] = info.getDataType();
            }
            if (this.values != null) {
                this.values[index.intValue()] = info.getValue();
            }
        });
        this.failedMeasurementIndex2Info.clear();
    }

    @Override
    public Map<Integer, InsertBaseStatement.FailedMeasurementInfo> getFailedMeasurementInfoMap() {
        return this.failedMeasurementIndex2Info;
    }

    @Override
    public void semanticCheck() {
        super.semanticCheck();
        if (this.measurements.length != this.values.length) {
            throw new SemanticException(String.format("the measurementList's size %d is not consistent with the valueList's size %d", this.measurements.length, this.values.length));
        }
    }

    public boolean isNeedSplit() {
        return this.hasLogicalViewNeedProcess();
    }

    public List<InsertRowStatement> getSplitList() {
        if (!this.isNeedSplit()) {
            return Collections.singletonList(this);
        }
        Map<PartialPath, List<Pair<String, Integer>>> mapFromDeviceToMeasurementAndIndex = this.getMapFromDeviceToMeasurementAndIndex();
        ArrayList<InsertRowStatement> insertRowStatementList = new ArrayList<InsertRowStatement>();
        for (Map.Entry<PartialPath, List<Pair<String, Integer>>> entry : mapFromDeviceToMeasurementAndIndex.entrySet()) {
            List<Pair<String, Integer>> pairList = entry.getValue();
            InsertRowStatement statement = new InsertRowStatement();
            statement.setTime(this.time);
            statement.setNeedInferType(this.isNeedInferType);
            statement.setDevicePath(entry.getKey());
            statement.setAligned(this.isAligned);
            Object[] copiedValues = new Object[pairList.size()];
            String[] measurements = new String[pairList.size()];
            MeasurementSchema[] measurementSchemas = new MeasurementSchema[pairList.size()];
            TSDataType[] dataTypes = new TSDataType[pairList.size()];
            for (int i = 0; i < pairList.size(); ++i) {
                int realIndex = (Integer)pairList.get((int)i).right;
                copiedValues[i] = this.values[realIndex];
                measurements[i] = Objects.nonNull(this.measurements[realIndex]) ? (String)pairList.get((int)i).left : null;
                measurementSchemas[i] = this.measurementSchemas[realIndex];
                dataTypes[i] = this.dataTypes[realIndex];
                if (this.measurementIsAligned == null) continue;
                statement.setAligned(this.measurementIsAligned[realIndex]);
            }
            statement.setValues(copiedValues);
            statement.setMeasurements(measurements);
            statement.setMeasurementSchemas(measurementSchemas);
            statement.setDataTypes(dataTypes);
            statement.setFailedMeasurementIndex2Info(this.failedMeasurementIndex2Info);
            insertRowStatementList.add(statement);
        }
        return insertRowStatementList;
    }

    @Override
    public InsertBaseStatement removeLogicalView() {
        if (!this.isNeedSplit()) {
            return this;
        }
        List<InsertRowStatement> insertRowStatementList = this.getSplitList();
        if (insertRowStatementList.size() == 1) {
            return insertRowStatementList.get(0);
        }
        InsertRowsStatement insertRowsStatement = new InsertRowsStatement();
        insertRowsStatement.setInsertRowStatementList(insertRowStatementList);
        return insertRowsStatement;
    }

    @Override
    public ISchemaValidation getSchemaValidation() {
        return this;
    }

    @Override
    public List<ISchemaValidation> getSchemaValidationList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAfterSchemaValidation(MPPQueryContext context) throws QueryProcessException {
        if (this.isNeedInferType) {
            this.transferType(context == null ? ZoneId.systemDefault() : context.getZoneId());
        }
    }

    @Override
    public TSDataType getDataType(int index) {
        if (this.isNeedInferType && (this.dataTypes == null || this.dataTypes[index] == null)) {
            if (this.dataTypes == null) {
                this.dataTypes = new TSDataType[this.measurements.length];
            }
            this.dataTypes[index] = TypeInferenceUtils.getPredictedDataType(this.values[index], true);
            return this.dataTypes[index];
        }
        return this.dataTypes != null ? this.dataTypes[index] : null;
    }

    @Override
    public TSEncoding getEncoding(int index) {
        return null;
    }

    @Override
    public CompressionType getCompressionType(int index) {
        return null;
    }

    @Override
    public void validateDeviceSchema(boolean isAligned) {
        this.isAligned = isAligned;
    }

    @Override
    public void validateMeasurementSchema(int index, IMeasurementSchemaInfo measurementSchemaInfo) {
        if (this.measurementSchemas == null) {
            this.measurementSchemas = new MeasurementSchema[this.measurements.length];
        }
        if (measurementSchemaInfo == null) {
            this.measurementSchemas[index] = null;
        } else {
            if (measurementSchemaInfo.isLogicalView()) {
                if (this.logicalViewSchemaList == null || this.indexOfSourcePathsOfLogicalViews == null) {
                    this.logicalViewSchemaList = new ArrayList();
                    this.indexOfSourcePathsOfLogicalViews = new ArrayList();
                }
                this.logicalViewSchemaList.add(measurementSchemaInfo.getSchemaAsLogicalViewSchema());
                this.indexOfSourcePathsOfLogicalViews.add(index);
                return;
            }
            this.measurementSchemas[index] = measurementSchemaInfo.getSchemaAsMeasurementSchema();
        }
        if (this.isNeedInferType) {
            return;
        }
        try {
            this.selfCheckDataTypes(index);
        }
        catch (DataTypeMismatchException | PathNotExistException e) {
            throw new SemanticException(e);
        }
    }

    @Override
    public void validateMeasurementSchema(int index, IMeasurementSchemaInfo measurementSchemaInfo, boolean isAligned) {
        this.validateMeasurementSchema(index, measurementSchemaInfo);
        if (this.measurementIsAligned == null) {
            this.measurementIsAligned = new boolean[this.measurements.length];
            Arrays.fill(this.measurementIsAligned, this.isAligned);
        }
        this.measurementIsAligned[index] = isAligned;
    }

    @Override
    public boolean hasLogicalViewNeedProcess() {
        if (this.indexOfSourcePathsOfLogicalViews == null) {
            return false;
        }
        return !this.indexOfSourcePathsOfLogicalViews.isEmpty();
    }

    @Override
    public List<LogicalViewSchema> getLogicalViewSchemaList() {
        return this.logicalViewSchemaList;
    }

    @Override
    public List<Integer> getIndexListOfLogicalViewPaths() {
        return this.indexOfSourcePathsOfLogicalViews;
    }

    @Override
    public void recordRangeOfLogicalViewSchemaListNow() {
        if (this.logicalViewSchemaList != null) {
            this.recordedBeginOfLogicalViewSchemaList = this.recordedEndOfLogicalViewSchemaList;
            this.recordedEndOfLogicalViewSchemaList = this.logicalViewSchemaList.size();
        }
    }

    @Override
    public Pair<Integer, Integer> getRangeOfLogicalViewSchemaListRecorded() {
        return new Pair((Object)this.recordedBeginOfLogicalViewSchemaList, (Object)this.recordedEndOfLogicalViewSchemaList);
    }

    @TableModel
    public IDeviceID getTableDeviceID() {
        if (this.deviceID == null) {
            String[] deviceIdSegments = new String[this.getIdColumnIndices().size() + 1];
            deviceIdSegments[0] = this.getTableName();
            for (int i = 0; i < this.getIdColumnIndices().size(); ++i) {
                Integer columnIndex = this.getIdColumnIndices().get(i);
                deviceIdSegments[i + 1] = this.values[columnIndex] != null ? this.values[columnIndex].toString() : null;
            }
            this.deviceID = IDeviceID.Factory.DEFAULT_FACTORY.create(deviceIdSegments);
        }
        return this.deviceID;
    }

    @TableModel
    public IDeviceID getRawTableDeviceID() {
        return this.deviceID;
    }

    @Override
    @TableModel
    public Statement toRelationalStatement(MPPQueryContext context) {
        return new InsertRow(this, context);
    }

    @Override
    @TableModel
    public void insertColumn(int pos, ColumnSchema columnSchema) {
        super.insertColumn(pos, columnSchema);
        Object[] tmpValues = new Object[this.values.length + 1];
        System.arraycopy(this.values, 0, tmpValues, 0, pos);
        System.arraycopy(this.values, pos, tmpValues, pos + 1, this.values.length - pos);
        this.values = tmpValues;
    }

    @Override
    @TableModel
    public void swapColumn(int src, int target) {
        super.swapColumn(src, target);
        CommonUtils.swapArray(this.values, src, target);
    }

    @Override
    protected long calculateBytesUsed() {
        return INSTANCE_SIZE + InsertNodeMemoryEstimator.sizeOfValues(this.values, this.measurementSchemas) + RamUsageEstimator.sizeOf((boolean[])this.measurementIsAligned) + InsertNodeMemoryEstimator.sizeOfIDeviceID(this.deviceID);
    }

    @Override
    protected void subRemoveAttributeColumns(List<Integer> columnsToKeep) {
        if (this.values != null) {
            this.values = columnsToKeep.stream().map(i -> this.values[i]).toArray();
        }
    }
}

