/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.concurrent;

import java.util.concurrent.Semaphore;

public class FiniteSemaphore {
    private final int capacity;
    private final Semaphore semaphore;
    private int permit;

    public FiniteSemaphore(int capacity, int permit) {
        if (capacity < permit) {
            throw new IllegalArgumentException("Capacity should be larger than initial permits.");
        }
        this.capacity = capacity;
        this.semaphore = new Semaphore(permit);
        this.permit = permit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        FiniteSemaphore finiteSemaphore = this;
        synchronized (finiteSemaphore) {
            if (this.permit < this.capacity) {
                ++this.permit;
                this.semaphore.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() throws InterruptedException {
        this.semaphore.acquire();
        FiniteSemaphore finiteSemaphore = this;
        synchronized (finiteSemaphore) {
            --this.permit;
        }
    }
}

