/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.RegisteredServer;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class RegisterServerRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=435");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=437");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=436");
    private final RequestHeader requestHeader;
    private final RegisteredServer server;

    public RegisterServerRequest(RequestHeader requestHeader, RegisteredServer server) {
        this.requestHeader = requestHeader;
        this.server = server;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public RegisteredServer getServer() {
        return this.server;
    }

    protected RegisterServerRequest(RegisterServerRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((RegisterServerRequestBuilder)b).requestHeader;
        this.server = ((RegisterServerRequestBuilder)b).server;
    }

    public static RegisterServerRequestBuilder<?, ?> builder() {
        return new RegisterServerRequestBuilderImpl();
    }

    public RegisterServerRequestBuilder<?, ?> toBuilder() {
        return new RegisterServerRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegisterServerRequest)) {
            return false;
        }
        RegisterServerRequest other = (RegisterServerRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        RegisteredServer this$server = this.getServer();
        RegisteredServer other$server = other.getServer();
        return !(this$server == null ? other$server != null : !((Object)this$server).equals(other$server));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RegisterServerRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        RegisteredServer $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : ((Object)$server).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "RegisterServerRequest(requestHeader=" + this.getRequestHeader() + ", server=" + this.getServer() + ")";
    }

    private static final class RegisterServerRequestBuilderImpl
    extends RegisterServerRequestBuilder<RegisterServerRequest, RegisterServerRequestBuilderImpl> {
        private RegisterServerRequestBuilderImpl() {
        }

        @Override
        protected RegisterServerRequestBuilderImpl self() {
            return this;
        }

        @Override
        public RegisterServerRequest build() {
            return new RegisterServerRequest(this);
        }
    }

    public static abstract class RegisterServerRequestBuilder<C extends RegisterServerRequest, B extends RegisterServerRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private RegisteredServer server;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            RegisterServerRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(RegisterServerRequest instance, RegisterServerRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.server(instance.server);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B server(RegisteredServer server) {
            this.server = server;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "RegisterServerRequest.RegisterServerRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", server=" + this.server + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<RegisterServerRequest> {
        @Override
        public Class<RegisterServerRequest> getType() {
            return RegisterServerRequest.class;
        }

        @Override
        public RegisterServerRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            RegisteredServer server = (RegisteredServer)decoder.readStruct("Server", RegisteredServer.TYPE_ID);
            return new RegisterServerRequest(requestHeader, server);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, RegisterServerRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeStruct("Server", (Object)value.getServer(), RegisteredServer.TYPE_ID);
        }
    }
}

