/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.LogicalIndexNavigation;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.PatternAggregator;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.PatternVariableRecognizer;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.expression.PatternExpressionComputation;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.matcher.ArrayView;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.matcher.MatchResult;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.matcher.Matcher;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.Partition;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.utils.ColumnList;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.utils.RowComparator;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.RowsPerMatch;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.SkipToPosition;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.Binary;

public final class PatternPartitionExecutor {
    private final int partitionStart;
    private final int partitionEnd;
    private final Partition partition;
    private final List<ColumnList> sortedColumns;
    private final RowComparator peerGroupComparator;
    private int peerGroupStart;
    private int peerGroupEnd;
    private final List<Integer> outputChannels;
    private int currentGroupIndex = -1;
    private int currentPosition;
    private final RowsPerMatch rowsPerMatch;
    private final SkipToPosition skipToPosition;
    private final Optional<LogicalIndexNavigation> skipToNavigation;
    private final Matcher matcher;
    private final List<PatternVariableRecognizer.PatternVariableComputation> patternVariableComputations;
    private final PatternAggregator[] patternAggregators;
    private final List<PatternExpressionComputation> measureComputations;
    private final List<String> labelNames;
    private int lastSkippedPosition;
    private int lastMatchedPosition;
    private long matchNumber;

    public PatternPartitionExecutor(List<TsBlock> tsBlocks, List<TSDataType> dataTypes, int startIndexInFirstBlock, int endIndexInLastBlock, List<Integer> outputChannels, List<Integer> sortChannels, RowsPerMatch rowsPerMatch, SkipToPosition skipToPosition, Optional<LogicalIndexNavigation> skipToNavigation, Matcher matcher, List<PatternVariableRecognizer.PatternVariableComputation> patternVariableComputations, List<PatternAggregator> patternAggregators, List<PatternExpressionComputation> measureComputations, List<String> labelNames) {
        this.partition = new Partition(tsBlocks, startIndexInFirstBlock, endIndexInLastBlock);
        this.partitionStart = startIndexInFirstBlock;
        this.partitionEnd = startIndexInFirstBlock + this.partition.getPositionCount();
        this.outputChannels = ImmutableList.copyOf(outputChannels);
        this.rowsPerMatch = rowsPerMatch;
        this.skipToPosition = skipToPosition;
        this.skipToNavigation = skipToNavigation;
        this.matcher = matcher;
        this.patternVariableComputations = ImmutableList.copyOf(patternVariableComputations);
        this.patternAggregators = patternAggregators.toArray(new PatternAggregator[0]);
        this.measureComputations = ImmutableList.copyOf(measureComputations);
        this.labelNames = ImmutableList.copyOf(labelNames);
        this.lastSkippedPosition = this.partitionStart - 1;
        this.lastMatchedPosition = this.partitionStart - 1;
        this.matchNumber = 1L;
        ArrayList<TSDataType> sortDataTypes = new ArrayList<TSDataType>();
        for (int channel : sortChannels) {
            TSDataType dataType = dataTypes.get(channel);
            sortDataTypes.add(dataType);
        }
        this.peerGroupComparator = new RowComparator(sortDataTypes);
        this.sortedColumns = this.partition.getSortedColumnList(sortChannels);
        this.currentPosition = this.partitionStart;
        this.updatePeerGroup();
    }

    public boolean hasNext() {
        return this.currentPosition < this.partitionEnd;
    }

    public void processNextRow(TsBlockBuilder builder) {
        if (this.currentPosition == this.peerGroupEnd) {
            this.updatePeerGroup();
        }
        if (!this.isSkipped(this.currentPosition)) {
            int patternStart = this.currentPosition;
            int searchStart = this.partitionStart;
            int searchEnd = this.partitionEnd;
            PatternVariableRecognizer patternVariableRecognizer = new PatternVariableRecognizer(this.matchNumber, patternStart, this.partitionStart, searchStart, searchEnd, this.patternVariableComputations, this.partition);
            MatchResult matchResult = this.matcher.run(patternVariableRecognizer);
            if (!matchResult.isMatched()) {
                if (this.rowsPerMatch.isUnmatchedRows() && !this.isMatched(this.currentPosition)) {
                    this.outputUnmatchedRow(builder);
                }
                this.lastSkippedPosition = this.currentPosition;
            } else if (matchResult.getLabels().length() == 0) {
                if (this.rowsPerMatch.isEmptyMatches()) {
                    this.outputEmptyMatch(builder);
                }
                this.lastSkippedPosition = this.currentPosition;
                ++this.matchNumber;
            } else {
                for (PatternAggregator patternAggregator : this.patternAggregators) {
                    patternAggregator.reset();
                }
                if (this.rowsPerMatch.isOneRow()) {
                    this.outputOneRowPerMatch(builder, matchResult, patternStart, searchStart, searchEnd);
                } else {
                    this.outputAllRowsPerMatch(builder, matchResult, searchStart, searchEnd);
                }
                this.updateLastMatchedPosition(matchResult, patternStart);
                this.skipAfterMatch(matchResult, patternStart, searchStart, searchEnd);
                ++this.matchNumber;
            }
        }
        ++this.currentPosition;
    }

    private boolean isSkipped(int position) {
        return position <= this.lastSkippedPosition;
    }

    private boolean isMatched(int position) {
        return position <= this.lastMatchedPosition;
    }

    private void outputUnmatchedRow(TsBlockBuilder builder) {
        int i;
        int index = this.currentPosition - this.partitionStart;
        Partition.PartitionIndex partitionIndex = this.partition.getPartitionIndex(index);
        int tsBlockIndex = partitionIndex.getTsBlockIndex();
        int offsetInTsBlock = partitionIndex.getOffsetInTsBlock();
        TsBlock tsBlock = this.partition.getTsBlock(tsBlockIndex);
        int channel = 0;
        for (i = 0; i < this.outputChannels.size(); ++i) {
            Column column = tsBlock.getColumn(this.outputChannels.get(i).intValue());
            ColumnBuilder columnBuilder = builder.getColumnBuilder(i);
            columnBuilder.write(column, offsetInTsBlock);
            ++channel;
        }
        for (i = 0; i < this.measureComputations.size(); ++i) {
            builder.getColumnBuilder(channel).appendNull();
            ++channel;
        }
        builder.declarePosition();
    }

    private void outputEmptyMatch(TsBlockBuilder builder) {
        int index = this.currentPosition - this.partitionStart;
        Partition.PartitionIndex partitionIndex = this.partition.getPartitionIndex(index);
        int tsBlockIndex = partitionIndex.getTsBlockIndex();
        int offsetInTsBlock = partitionIndex.getOffsetInTsBlock();
        TsBlock tsBlock = this.partition.getTsBlock(tsBlockIndex);
        int channel = 0;
        for (int i = 0; i < this.outputChannels.size(); ++i) {
            Column column = tsBlock.getColumn(this.outputChannels.get(i).intValue());
            ColumnBuilder columnBuilder = builder.getColumnBuilder(i);
            columnBuilder.write(column, offsetInTsBlock);
            ++channel;
        }
        for (PatternExpressionComputation measureComputation : this.measureComputations) {
            Object result = measureComputation.computeEmpty(this.matchNumber);
            if (result == null) {
                builder.getColumnBuilder(channel).appendNull();
            } else {
                builder.getColumnBuilder(channel).writeObject(result);
            }
            ++channel;
        }
        builder.declarePosition();
    }

    private void outputOneRowPerMatch(TsBlockBuilder builder, MatchResult matchResult, int patternStart, int searchStart, int searchEnd) {
        int index = this.currentPosition - this.partitionStart;
        Partition.PartitionIndex partitionIndex = this.partition.getPartitionIndex(index);
        int tsBlockIndex = partitionIndex.getTsBlockIndex();
        int offsetInTsBlock = partitionIndex.getOffsetInTsBlock();
        TsBlock tsBlock = this.partition.getTsBlock(tsBlockIndex);
        int channel = 0;
        for (int i = 0; i < this.outputChannels.size(); ++i) {
            Column column = tsBlock.getColumn(this.outputChannels.get(i).intValue());
            ColumnBuilder columnBuilder = builder.getColumnBuilder(i);
            columnBuilder.write(column, offsetInTsBlock);
            ++channel;
        }
        ArrayView labels = matchResult.getLabels();
        for (PatternExpressionComputation measureComputation : this.measureComputations) {
            Object result = measureComputation.compute(patternStart + labels.length() - 1, labels, this.patternAggregators, this.partitionStart, searchStart, searchEnd, patternStart, this.matchNumber, this.labelNames, this.partition);
            if (result == null) {
                builder.getColumnBuilder(channel).appendNull();
            } else if (result instanceof String) {
                String str = (String)result;
                byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
                Binary binary = new Binary(bytes);
                builder.getColumnBuilder(channel).writeBinary(binary);
            } else {
                builder.getColumnBuilder(channel).writeObject(result);
            }
            ++channel;
        }
        builder.declarePosition();
    }

    private void outputAllRowsPerMatch(TsBlockBuilder builder, MatchResult matchResult, int searchStart, int searchEnd) {
        ArrayView labels = matchResult.getLabels();
        ArrayView exclusions = matchResult.getExclusions();
        int start = 0;
        for (int index = 0; index < exclusions.length(); index += 2) {
            int end = exclusions.get(index);
            for (int i = start; i < end; ++i) {
                this.outputRow(builder, labels, this.currentPosition + i, searchStart, searchEnd);
            }
            start = exclusions.get(index + 1);
        }
        for (int i = start; i < labels.length(); ++i) {
            this.outputRow(builder, labels, this.currentPosition + i, searchStart, searchEnd);
        }
    }

    private void outputRow(TsBlockBuilder builder, ArrayView labels, int position, int searchStart, int searchEnd) {
        Partition.PartitionIndex partitionIndex = this.partition.getPartitionIndex(position);
        int tsBlockIndex = partitionIndex.getTsBlockIndex();
        int offsetInTsBlock = partitionIndex.getOffsetInTsBlock();
        TsBlock tsBlock = this.partition.getTsBlock(tsBlockIndex);
        int channel = 0;
        for (int i = 0; i < this.outputChannels.size(); ++i) {
            Column column = tsBlock.getColumn(this.outputChannels.get(i).intValue());
            ColumnBuilder columnBuilder = builder.getColumnBuilder(i);
            columnBuilder.write(column, offsetInTsBlock);
            ++channel;
        }
        for (PatternExpressionComputation measureComputation : this.measureComputations) {
            Object result = measureComputation.compute(position, labels, this.patternAggregators, this.partitionStart, searchStart, searchEnd, this.currentPosition, this.matchNumber, this.labelNames, this.partition);
            if (result == null) {
                builder.getColumnBuilder(channel).appendNull();
            } else if (result instanceof String) {
                String str = (String)result;
                byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
                Binary binary = new Binary(bytes);
                builder.getColumnBuilder(channel).writeBinary(binary);
            } else {
                builder.getColumnBuilder(channel).writeObject(result);
            }
            ++channel;
        }
        builder.declarePosition();
    }

    private void updateLastMatchedPosition(MatchResult matchResult, int patternStart) {
        int lastPositionInMatch = patternStart + matchResult.getLabels().length() - 1;
        this.lastMatchedPosition = Math.max(this.lastMatchedPosition, lastPositionInMatch);
    }

    private void skipAfterMatch(MatchResult matchResult, int patternStart, int searchStart, int searchEnd) {
        ArrayView labels = matchResult.getLabels();
        switch (this.skipToPosition) {
            case PAST_LAST: {
                this.lastSkippedPosition = patternStart + labels.length() - 1;
                break;
            }
            case NEXT: {
                this.lastSkippedPosition = this.currentPosition;
                break;
            }
            case LAST: 
            case FIRST: {
                Preconditions.checkState((boolean)this.skipToNavigation.isPresent(), (String)"skip to navigation is missing for SKIP TO %s", (Object)this.skipToPosition.name());
                int position = this.skipToNavigation.get().resolvePosition(patternStart + labels.length() - 1, labels, searchStart, searchEnd, patternStart);
                if (position == -1) {
                    throw new SemanticException("AFTER MATCH SKIP TO failed: pattern variable is not present in match");
                }
                if (position == patternStart) {
                    throw new SemanticException("AFTER MATCH SKIP TO failed: cannot skip to first row of match");
                }
                this.lastSkippedPosition = position - 1;
                break;
            }
            default: {
                throw new IllegalStateException("unexpected SKIP TO position: " + (Object)((Object)this.skipToPosition));
            }
        }
    }

    private void updatePeerGroup() {
        ++this.currentGroupIndex;
        this.peerGroupStart = this.currentPosition;
        this.peerGroupEnd = this.peerGroupStart + 1;
        while (this.peerGroupEnd < this.partitionEnd && this.peerGroupComparator.equalColumnLists(this.sortedColumns, this.peerGroupStart - this.partitionStart, this.peerGroupEnd - this.partitionStart)) {
            ++this.peerGroupEnd;
        }
    }
}

