/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.reporter.prometheus;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.iotdb.metrics.config.MetricConfig;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.utils.MetricType;

class PrometheusTextWriter
extends FilterWriter {
    private static final MetricConfig METRIC_CONFIG = MetricConfigDescriptor.getInstance().getMetricConfig();

    public PrometheusTextWriter(Writer out) {
        super(out);
    }

    public void writeHelp(String name) throws IOException {
        this.write("# HELP ");
        this.write(name);
        this.write(10);
    }

    public void writeType(String name, MetricType type) throws IOException {
        this.write("# TYPE ");
        this.write(name);
        this.write(32);
        switch (type) {
            case GAUGE: 
            case AUTO_GAUGE: {
                this.write("gauge");
                break;
            }
            case COUNTER: 
            case RATE: {
                this.write("counter");
                break;
            }
            case TIMER: 
            case HISTOGRAM: {
                this.write("summary");
                break;
            }
        }
        this.write(10);
    }

    public void writeSample(String name, Map<String, String> labels, Object value) throws IOException {
        this.write(name);
        this.write(123);
        this.write("cluster=\"");
        this.write(METRIC_CONFIG.getClusterName());
        this.write("\",nodeType=\"");
        this.write(METRIC_CONFIG.getNodeType().toString());
        this.write("\",nodeId=\"");
        this.write(String.valueOf(METRIC_CONFIG.getNodeId()));
        this.write("\",");
        if (labels.size() > 0) {
            for (Map.Entry<String, String> entry : labels.entrySet()) {
                this.write(entry.getKey());
                this.write("=\"");
                this.write(entry.getValue());
                this.write("\",");
            }
        }
        this.write(125);
        this.write(32);
        this.write(value.toString());
        this.write(10);
    }
}

