/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail.utils;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.apache.james.mailbox.store.mail.model.MimeMessageId;
import org.apache.james.mailbox.store.mail.model.Subject;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.Header;
import org.apache.james.mime4j.dom.field.UnstructuredField;
import org.apache.james.mime4j.field.UnstructuredFieldImpl;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.util.MimeUtil;

public class MimeMessageHeadersUtil {
    private static final Splitter SPLITTER = Splitter.on((char)' ').omitEmptyStrings().trimResults();

    public static Optional<MimeMessageId> parseMimeMessageId(Header headers) {
        return Optional.ofNullable(headers.getField("Message-ID")).map(field -> new MimeMessageId(field.getBody()));
    }

    public static Optional<MimeMessageId> parseInReplyTo(Header headers) {
        return Optional.ofNullable(headers.getField("In-Reply-To")).map(Field::getBody).map(MimeUtil::unfold).map(String::trim).map(MimeMessageId::new);
    }

    public static Optional<List<MimeMessageId>> parseReferences(Header headers) {
        List mimeMessageIdFields = headers.getFields("References");
        if (!mimeMessageIdFields.isEmpty()) {
            List mimeMessageIdList = (List)mimeMessageIdFields.stream().map(Field::getBody).map(MimeUtil::unfold).flatMap(arg_0 -> ((Splitter)SPLITTER).splitToStream(arg_0)).map(MimeMessageId::new).collect(ImmutableList.toImmutableList());
            return Optional.of(mimeMessageIdList);
        }
        return Optional.empty();
    }

    public static Optional<Subject> parseSubject(Header headers) {
        return Optional.ofNullable(headers.getField("Subject")).map(field -> {
            if (!(field instanceof UnstructuredField)) {
                field = UnstructuredFieldImpl.PARSER.parse(field, DecodeMonitor.SILENT);
            }
            return (UnstructuredField)field;
        }).map(unstructuredField -> new Subject(unstructuredField.getValue().trim()));
    }
}

