/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mail;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.string;
import java.io.Serializable;
import org.apache.james.jmap.core.CapabilityIdentifier$;
import org.apache.james.jmap.json.MailboxSerializer;
import org.apache.james.jmap.mail.InvalidPatchException;
import org.apache.james.jmap.mail.InvalidUpdateException;
import org.apache.james.jmap.mail.MailboxPatchObject$;
import org.apache.james.jmap.mail.PatchUpdateValidationException;
import org.apache.james.jmap.mail.Rights;
import org.apache.james.jmap.mail.SharedWithAnyoneValidator$;
import org.apache.james.jmap.mail.SharedWithResetUpdate;
import org.apache.james.jmap.mail.Update;
import play.api.libs.json.JsError;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class SharedWithResetUpdate$
implements Serializable {
    public static final SharedWithResetUpdate$ MODULE$ = new SharedWithResetUpdate$();

    public Either<PatchUpdateValidationException, Update> parse(MailboxSerializer serializer, Set<Refined<String, string.Uri>> capabilities, JsValue newValue) {
        if (capabilities.contains((Object)new Refined((Object)CapabilityIdentifier$.MODULE$.JAMES_SHARES()))) {
            boolean bl = false;
            JsSuccess jsSuccess = null;
            JsResult<Rights> jsResult = serializer.deserializeRights(newValue);
            if (jsResult instanceof JsSuccess) {
                bl = true;
                jsSuccess = (JsSuccess)jsResult;
                Rights value = (Rights)jsSuccess.value();
                if (!SharedWithAnyoneValidator$.MODULE$.areValidPatches(value.rights())) {
                    return new Left((Object)new InvalidPatchException("only the `Post` right can be granted to the identifier `anyone`"));
                }
            }
            if (bl) {
                Rights value = (Rights)jsSuccess.value();
                return new Right((Object)new SharedWithResetUpdate(value));
            }
            if (jsResult instanceof JsError) {
                JsError jsError = (JsError)jsResult;
                Seq errors = jsError.errors();
                return new Left((Object)new InvalidUpdateException((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"sharedWith")).value(), "Specified value do not match the expected JSON format: " + errors));
            }
            throw new MatchError(jsResult);
        }
        return MailboxPatchObject$.MODULE$.notFound("sharedWith");
    }

    public SharedWithResetUpdate apply(Rights rights) {
        return new SharedWithResetUpdate(rights);
    }

    public Option<Rights> unapply(SharedWithResetUpdate x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)x$0.rights());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SharedWithResetUpdate$.class);
    }

    private SharedWithResetUpdate$() {
    }
}

