/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.quota;

import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaLimitValue;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.core.quota.QuotaUsageValue;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.QuotaManager;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class NoQuotaManager
implements QuotaManager {
    public Quota<QuotaCountLimit, QuotaCountUsage> getMessageQuota(QuotaRoot quotaRoot) {
        return Quota.builder().used((QuotaUsageValue)QuotaCountUsage.count((long)0L)).computedLimit((QuotaLimitValue)QuotaCountLimit.unlimited()).build();
    }

    public Quota<QuotaSizeLimit, QuotaSizeUsage> getStorageQuota(QuotaRoot quotaRoot) {
        return Quota.builder().used((QuotaUsageValue)QuotaSizeUsage.size((long)0L)).computedLimit((QuotaLimitValue)QuotaSizeLimit.unlimited()).build();
    }

    public QuotaManager.Quotas getQuotas(QuotaRoot quotaRoot) {
        return new QuotaManager.Quotas(this.getMessageQuota(quotaRoot), this.getStorageQuota(quotaRoot));
    }

    public Publisher<QuotaManager.Quotas> getQuotasReactive(QuotaRoot quotaRoot) {
        return Mono.just((Object)this.getQuotas(quotaRoot));
    }
}

