/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.objectstorage.aws;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.james.blob.objectstorage.aws.sse.S3SSECustomerKeyFactory;

public record S3RequestOption(SSEC ssec) {
    public static S3RequestOption DEFAULT = new S3RequestOption(SSEC.DISABLED);

    public record SSEC(boolean enable, Optional<S3SSECustomerKeyFactory> sseCustomerKeyFactory) {
        static SSEC DISABLED = new SSEC(false, Optional.empty());

        public SSEC {
            Preconditions.checkArgument((!enable || sseCustomerKeyFactory.isPresent() ? 1 : 0) != 0, (Object)"SSE Customer Key Factory must be present when SSE is enabled");
        }
    }
}

