/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.postgres;

import org.apache.james.backends.postgres.PostgresDataDefinition;
import org.apache.james.backends.postgres.PostgresIndex;
import org.apache.james.backends.postgres.PostgresTable;
import org.jooq.Constraint;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

public interface PostgresBlobStorageDataDefinition {
    public static final PostgresDataDefinition MODULE = PostgresDataDefinition.builder().addTable(new PostgresTable[]{PostgresBlobStorageTable.TABLE}).addIndex(new PostgresIndex[]{PostgresBlobStorageTable.BUCKET_NAME_INDEX}).build();

    public static interface PostgresBlobStorageTable {
        public static final Table<Record> TABLE_NAME = DSL.table((String)"blob_storage");
        public static final Field<String> BUCKET_NAME = DSL.field((String)"bucket_name", (DataType)SQLDataType.VARCHAR((int)200).notNull());
        public static final Field<String> BLOB_ID = DSL.field((String)"blob_id", (DataType)SQLDataType.VARCHAR((int)200).notNull());
        public static final Field<byte[]> DATA = DSL.field((String)"data", (DataType)SQLDataType.BLOB.notNull());
        public static final Field<Integer> SIZE = DSL.field((String)"size", (DataType)SQLDataType.INTEGER.notNull());
        public static final PostgresTable TABLE = PostgresTable.name((String)TABLE_NAME.getName()).createTableStep((dsl, tableName) -> dsl.createTableIfNotExists(tableName).column(BUCKET_NAME).column(BLOB_ID).column(DATA).column(SIZE).constraint((Constraint)DSL.primaryKey((Field[])new Field[]{BUCKET_NAME, BLOB_ID}))).disableRowLevelSecurity().build();
        public static final PostgresIndex BUCKET_NAME_INDEX = PostgresIndex.name((String)"blob_storage_bucket_name_index").createIndexStep((dsl, indexName) -> dsl.createIndexIfNotExists(indexName).on(TABLE_NAME, new OrderField[]{BUCKET_NAME}));
    }
}

