/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres.mail;

import jakarta.inject.Inject;
import java.util.List;
import java.util.Set;
import org.apache.james.mailbox.model.MailboxAnnotation;
import org.apache.james.mailbox.model.MailboxAnnotationKey;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.postgres.PostgresMailboxId;
import org.apache.james.mailbox.postgres.mail.dao.PostgresMailboxAnnotationDAO;
import org.apache.james.mailbox.store.mail.AnnotationMapper;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresAnnotationMapper
implements AnnotationMapper {
    private final PostgresMailboxAnnotationDAO annotationDAO;

    @Inject
    public PostgresAnnotationMapper(PostgresMailboxAnnotationDAO annotationDAO) {
        this.annotationDAO = annotationDAO;
    }

    public List<MailboxAnnotation> getAllAnnotations(MailboxId mailboxId) {
        return (List)this.getAllAnnotationsReactive(mailboxId).collectList().block();
    }

    public Flux<MailboxAnnotation> getAllAnnotationsReactive(MailboxId mailboxId) {
        return this.annotationDAO.getAllAnnotations((PostgresMailboxId)mailboxId);
    }

    public List<MailboxAnnotation> getAnnotationsByKeys(MailboxId mailboxId, Set<MailboxAnnotationKey> keys) {
        return (List)this.getAnnotationsByKeysReactive(mailboxId, keys).collectList().block();
    }

    public Flux<MailboxAnnotation> getAnnotationsByKeysReactive(MailboxId mailboxId, Set<MailboxAnnotationKey> keys) {
        return this.annotationDAO.getAnnotationsByKeys((PostgresMailboxId)mailboxId, keys);
    }

    public List<MailboxAnnotation> getAnnotationsByKeysWithOneDepth(MailboxId mailboxId, Set<MailboxAnnotationKey> keys) {
        return (List)this.getAnnotationsByKeysWithOneDepthReactive(mailboxId, keys).collectList().block();
    }

    public Flux<MailboxAnnotation> getAnnotationsByKeysWithOneDepthReactive(MailboxId mailboxId, Set<MailboxAnnotationKey> keys) {
        return Flux.fromIterable(keys).flatMap(mailboxAnnotationKey -> this.annotationDAO.getAnnotationsByKeyLike((PostgresMailboxId)mailboxId, (MailboxAnnotationKey)mailboxAnnotationKey).filter(annotation -> mailboxAnnotationKey.isParentOrIsEqual(annotation.getKey())));
    }

    public List<MailboxAnnotation> getAnnotationsByKeysWithAllDepth(MailboxId mailboxId, Set<MailboxAnnotationKey> keys) {
        return (List)this.getAnnotationsByKeysWithAllDepthReactive(mailboxId, keys).collectList().block();
    }

    public Flux<MailboxAnnotation> getAnnotationsByKeysWithAllDepthReactive(MailboxId mailboxId, Set<MailboxAnnotationKey> keys) {
        return Flux.fromIterable(keys).flatMap(mailboxAnnotationKey -> this.annotationDAO.getAnnotationsByKeyLike((PostgresMailboxId)mailboxId, (MailboxAnnotationKey)mailboxAnnotationKey).filter(annotation -> mailboxAnnotationKey.isAncestorOrIsEqual(annotation.getKey())));
    }

    public void deleteAnnotation(MailboxId mailboxId, MailboxAnnotationKey key) {
        this.deleteAnnotationReactive(mailboxId, key).block();
    }

    public Mono<Void> deleteAnnotationReactive(MailboxId mailboxId, MailboxAnnotationKey key) {
        return this.annotationDAO.deleteAnnotation((PostgresMailboxId)mailboxId, key);
    }

    public void insertAnnotation(MailboxId mailboxId, MailboxAnnotation mailboxAnnotation) {
        this.insertAnnotationReactive(mailboxId, mailboxAnnotation).block();
    }

    public Mono<Void> insertAnnotationReactive(MailboxId mailboxId, MailboxAnnotation mailboxAnnotation) {
        return this.annotationDAO.insertAnnotation((PostgresMailboxId)mailboxId, mailboxAnnotation);
    }

    public boolean exist(MailboxId mailboxId, MailboxAnnotation mailboxAnnotation) {
        return (Boolean)this.existReactive(mailboxId, mailboxAnnotation).block();
    }

    public Mono<Boolean> existReactive(MailboxId mailboxId, MailboxAnnotation mailboxAnnotation) {
        return this.annotationDAO.exist((PostgresMailboxId)mailboxId, mailboxAnnotation.getKey());
    }

    public int countAnnotations(MailboxId mailboxId) {
        return (Integer)this.countAnnotationsReactive(mailboxId).block();
    }

    public Mono<Integer> countAnnotationsReactive(MailboxId mailboxId) {
        return this.annotationDAO.countAnnotations((PostgresMailboxId)mailboxId);
    }
}

