/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres.mail;

import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.postgres.mail.dao.PostgresMailboxDAO;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import reactor.core.publisher.Mono;

public class PostgresModSeqProvider
implements ModSeqProvider {
    private final PostgresMailboxDAO mailboxDAO;

    public PostgresModSeqProvider(PostgresMailboxDAO mailboxDAO) {
        this.mailboxDAO = mailboxDAO;
    }

    public ModSeq nextModSeq(Mailbox mailbox) throws MailboxException {
        return this.nextModSeq(mailbox.getMailboxId());
    }

    public ModSeq nextModSeq(MailboxId mailboxId) throws MailboxException {
        return (ModSeq)this.nextModSeqReactive(mailboxId).blockOptional().orElseThrow(() -> new MailboxException("Can not retrieve modseq for " + String.valueOf(mailboxId)));
    }

    public ModSeq highestModSeq(Mailbox mailbox) {
        return (ModSeq)this.highestModSeqReactive(mailbox).block();
    }

    public Mono<ModSeq> highestModSeqReactive(Mailbox mailbox) {
        return this.getHighestModSeq(mailbox.getMailboxId());
    }

    private Mono<ModSeq> getHighestModSeq(MailboxId mailboxId) {
        return this.mailboxDAO.findHighestModSeqByMailboxId(mailboxId).defaultIfEmpty((Object)ModSeq.first());
    }

    public ModSeq highestModSeq(MailboxId mailboxId) {
        return (ModSeq)this.getHighestModSeq(mailboxId).block();
    }

    public Mono<ModSeq> nextModSeqReactive(MailboxId mailboxId) {
        return this.mailboxDAO.incrementAndGetModSeq(mailboxId).defaultIfEmpty((Object)ModSeq.first());
    }

    public static class Factory {
        private final PostgresExecutor.Factory executorFactory;

        public Factory(PostgresExecutor.Factory executorFactory) {
            this.executorFactory = executorFactory;
        }

        public PostgresModSeqProvider create(MailboxSession session) {
            PostgresExecutor postgresExecutor = this.executorFactory.create(session.getUser().getDomainPart());
            return new PostgresModSeqProvider(new PostgresMailboxDAO(postgresExecutor));
        }
    }
}

