/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util;

import java.time.Instant;
import java.util.UUID;

public final class CombUtil {
    private CombUtil() {
    }

    public static long getPrefix(UUID comb) {
        return comb.getMostSignificantBits() >>> 16;
    }

    public static long getSuffix(UUID comb) {
        return comb.getLeastSignificantBits() & 0xFFFFFFFFFFFFL;
    }

    public static Instant getPrefixInstant(UUID comb) {
        long milliseconds = CombUtil.getPrefix(comb);
        return Instant.ofEpochMilli(milliseconds);
    }

    public static Instant getSuffixInstant(UUID comb) {
        long milliseconds = CombUtil.getSuffix(comb);
        return Instant.ofEpochMilli(milliseconds);
    }
}

