/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.request.builder.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.sling.api.request.RequestParameter;
import org.jetbrains.annotations.NotNull;

public class RequestParameterImpl
implements RequestParameter {
    @NotNull
    private final String name;
    private final byte @NotNull [] value;
    @NotNull
    private final Charset encoding;
    private final String contentType;
    private final String fileName;
    private final boolean isFormField;

    public RequestParameterImpl(@NotNull String name, @NotNull String value) {
        this(name, value, StandardCharsets.UTF_8);
    }

    public RequestParameterImpl(@NotNull String name, @NotNull String value, @NotNull Charset encoding) {
        this(name, value.getBytes(encoding), encoding, null, null, true);
    }

    public RequestParameterImpl(@NotNull String name, byte @NotNull [] value, String fileName, String contentType) {
        this(name, value, StandardCharsets.UTF_8, fileName, contentType, false);
    }

    private RequestParameterImpl(@NotNull String name, byte @NotNull [] value, @NotNull Charset encoding, String fileName, String contentType, boolean isFormField) {
        this.name = name;
        this.value = value;
        this.contentType = contentType;
        this.encoding = encoding;
        this.fileName = fileName;
        this.isFormField = isFormField;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public byte[] get() {
        return this.value;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.get());
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public long getSize() {
        return this.get().length;
    }

    @Override
    @NotNull
    public String getString() {
        return new String(this.value, this.encoding);
    }

    @Override
    @NotNull
    public String getString(@NotNull String encoding) throws UnsupportedEncodingException {
        return new String(this.value, encoding);
    }

    @Override
    public boolean isFormField() {
        return this.isFormField;
    }

    public String toString() {
        return this.getString();
    }
}

