/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.core.impl;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Objects;
import org.apache.sling.auth.core.AuthUtil;
import org.apache.sling.auth.core.impl.AbstractAuthenticationHandlerHolder;
import org.apache.sling.auth.core.impl.AuthenticationHandlerWrapper;
import org.apache.sling.auth.core.spi.AuthenticationHandler;
import org.apache.sling.auth.core.spi.AuthenticationInfo;
import org.apache.sling.auth.core.spi.JakartaAuthenticationFeedbackHandler;
import org.apache.sling.auth.core.spi.JakartaAuthenticationHandler;
import org.osgi.framework.ServiceReference;
import org.osgi.util.converter.Converters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AuthenticationHandlerHolder
extends AbstractAuthenticationHandlerHolder {
    private final JakartaAuthenticationHandler handler;
    private final String authType;
    private final boolean browserOnlyRequestCredentials;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    AuthenticationHandlerHolder(String fullPath, JakartaAuthenticationHandler handler, ServiceReference<?> serviceReference) {
        super(fullPath, serviceReference);
        String browserOnly = (String)Converters.standardConverter().convert(serviceReference.getProperty("sling.auth.browser-only")).to(String.class);
        this.handler = handler;
        this.authType = (String)Converters.standardConverter().convert(serviceReference.getProperty("authtype")).to(String.class);
        this.browserOnlyRequestCredentials = "true".equalsIgnoreCase(browserOnly) || "yes".equalsIgnoreCase(browserOnly);
    }

    AuthenticationHandlerHolder(String fullPath, AuthenticationHandler handler, ServiceReference<?> serviceReference) {
        this(fullPath, AuthenticationHandlerWrapper.wrap(handler), serviceReference);
    }

    @Override
    protected JakartaAuthenticationFeedbackHandler getFeedbackHandler() {
        if (this.handler instanceof JakartaAuthenticationFeedbackHandler) {
            return (JakartaAuthenticationFeedbackHandler)((Object)this.handler);
        }
        return null;
    }

    @Override
    public AuthenticationInfo doExtractCredentials(HttpServletRequest request, HttpServletResponse response) {
        this.logDebugMessage("doExtractCredentials", request);
        return this.handler.extractCredentials(request, response);
    }

    @Override
    public boolean doRequestCredentials(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.doesRequestCredentials(request)) {
            this.logDebugMessage("doRequestCredentials", request);
            return this.handler.requestCredentials(request, response);
        }
        return false;
    }

    @Override
    public void doDropCredentials(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.logDebugMessage("doDropCredentials", request);
        this.handler.dropCredentials(request, response);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.authType, this.browserOnlyRequestCredentials, this.handler);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthenticationHandlerHolder other = (AuthenticationHandlerHolder)obj;
        return Objects.equals(this.authType, other.authType) && this.browserOnlyRequestCredentials == other.browserOnlyRequestCredentials && Objects.equals(this.handler, other.handler);
    }

    public String toString() {
        return this.handler.toString();
    }

    private boolean doesRequestCredentials(HttpServletRequest request) {
        if (this.browserOnlyRequestCredentials && !AuthUtil.isBrowserRequest(request)) {
            return false;
        }
        if (this.authType == null) {
            return true;
        }
        String requestLogin = AuthUtil.getAttributeOrParameter(request, "sling:authRequestLogin", null);
        return requestLogin == null || this.authType.equals(requestLogin);
    }

    private void logDebugMessage(String functionName, HttpServletRequest request) {
        if (this.logger.isDebugEnabled()) {
            String message = functionName + ": Using AuthenticationHandler class {} to request credentials for request {} {}";
            this.logger.debug(message, new Object[]{this.handler, request.getMethod(), request.getRequestURL()});
        }
    }
}

