/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.debug;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.request.RequestProgressTracker;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.propertytypes.ServiceDescription;
import org.osgi.service.component.propertytypes.ServiceVendor;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Designate(ocd=Config.class)
@Component(service={Filter.class}, property={"sling.filter.scope=REQUEST"})
@ServiceDescription(value="RequestProgressTracker dump filte")
@ServiceVendor(value="The Apache Software Foundation")
public class RequestProgressTrackerLogFilter
implements Filter {
    private final Logger log = LoggerFactory.getLogger(RequestProgressTrackerLogFilter.class);
    private int requestCounter;
    private Config configuration;
    private String[] extensions;
    static final int NANOSEC_TO_MSEC = 1000000;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(request, response);
        if (request instanceof SlingHttpServletRequest) {
            SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
            RequestProgressTracker rpt = slingRequest.getRequestProgressTracker();
            rpt.done();
            if (this.log.isDebugEnabled() && this.allowDuration(rpt) && this.allowExtension(this.extractExtension(slingRequest))) {
                if (this.configuration.compactLogFormat()) {
                    this.logCompactFormat(rpt);
                } else {
                    this.logDefaultFormat(rpt);
                }
            }
        }
    }

    public void destroy() {
    }

    private void logCompactFormat(RequestProgressTracker rpt) {
        Iterator messages = rpt.getMessages();
        StringBuilder sb = new StringBuilder("\n");
        while (messages.hasNext()) {
            sb.append((String)messages.next());
        }
        sb.setLength(sb.length() - 1);
        this.log.debug(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logDefaultFormat(RequestProgressTracker rpt) {
        int requestId = 0;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            requestId = ++this.requestCounter;
        }
        Iterator it = rpt.getMessages();
        while (it.hasNext()) {
            this.log.debug("REQUEST_{} - " + (String)it.next(), (Object)requestId);
        }
    }

    private String extractExtension(SlingHttpServletRequest request) {
        RequestPathInfo requestPathInfo = request.getRequestPathInfo();
        String extension = requestPathInfo.getExtension();
        if (extension == null) {
            String pathInfo = requestPathInfo.getResourcePath();
            int extensionIndex = pathInfo.lastIndexOf(46) + 1;
            extension = pathInfo.substring(extensionIndex);
        }
        return extension;
    }

    private boolean allowExtension(String extension) {
        return this.extensions == null || this.extensions.length == 0 || Arrays.binarySearch(this.extensions, extension) > -1;
    }

    private boolean allowDuration(RequestProgressTracker rpt) {
        long duration = rpt.getDuration() / 1000000L;
        return (long)this.configuration.minDurationMs() <= duration && duration <= (long)this.configuration.maxDurationMs();
    }

    private String[] sortAndClean(String[] strings) {
        if (strings == null || strings.length == 0) {
            return strings;
        }
        Arrays.sort(strings);
        int skip = 0;
        for (int i = strings.length - 1; i > -1; --i) {
            if (strings[i].length() != 0) continue;
            ++skip;
        }
        return skip == 0 ? strings : Arrays.copyOfRange(strings, skip, strings.length);
    }

    @Activate
    private void activate(Config config) {
        this.configuration = config;
        this.extensions = this.sortAndClean(this.configuration.extensions());
        this.log.debug("activated: extensions = {}, min = {}, max = {}, compact = {}", new Object[]{this.extensions, this.configuration.minDurationMs(), this.configuration.maxDurationMs(), this.configuration.compactLogFormat()});
    }

    @ObjectClassDefinition(name="Apache Sling Request Progress Tracker Log Filter", description="Filter that enables logging of request progress tracker information. To enable the log output, the category org.apache.sling.engine.impl.debug.RequestProgressTrackerLogFilter needs to be logged on debug level.")
    public static @interface Config {
        @AttributeDefinition(name="Extension filter", description="Only requests with the listed extensions will be logged. If no extensions are configured all requests are logged. Empty by default.")
        public String[] extensions() default {};

        @AttributeDefinition(name="Min duration (ms)", description="Only requests that take at least the minimum duration in milliseconds are logged. Default is 0.")
        public int minDurationMs() default 0;

        @AttributeDefinition(name="Max duration (ms)", description="Only requests that take at most the maximum duration in milliseconds are logged. Default is 2147483647, i.e. Integer.MAX_VALUE.")
        public int maxDurationMs() default 0x7FFFFFFF;

        @AttributeDefinition(name="Compact Log Format", description="Whether or not to use the compact format. In compact one log entry is logged per request, detailing the request progress tracker information in individual lines, like stack-traces. This keeps log files smaller and makes them more readable. In the older (non-compact) format, one log entry is printed per line, thus potentially containing more noise. Default is false.")
        public boolean compactLogFormat() default false;
    }
}

