/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.hierarchy;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.jackrabbit.jcr2spi.hierarchy.ChildPropertyEntries;
import org.apache.jackrabbit.jcr2spi.hierarchy.EntryFactory;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.PropertyEntry;
import org.apache.jackrabbit.spi.Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildPropertyEntriesImpl
implements ChildPropertyEntries {
    private static Logger log = LoggerFactory.getLogger(ChildPropertyEntriesImpl.class);
    private final Map<Name, Reference<PropertyEntry>> properties = new HashMap<Name, Reference<PropertyEntry>>();
    private final NodeEntry parent;
    private final EntryFactory factory;

    ChildPropertyEntriesImpl(NodeEntry parent, EntryFactory factory) {
        this.parent = parent;
        this.factory = factory;
    }

    @Override
    public boolean contains(Name propertyName) {
        return this.properties.containsKey(propertyName);
    }

    @Override
    public PropertyEntry get(Name propertyName) {
        Reference<PropertyEntry> ref = this.properties.get(propertyName);
        if (ref == null) {
            return null;
        }
        PropertyEntry entry = ref.get();
        if (entry == null) {
            entry = this.factory.createPropertyEntry(this.parent, propertyName);
            this.add(entry);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<PropertyEntry> getPropertyEntries() {
        Map<Name, Reference<PropertyEntry>> map = this.properties;
        synchronized (map) {
            HashSet<PropertyEntry> entries = new HashSet<PropertyEntry>(this.properties.size());
            for (Name propName : this.properties.keySet()) {
                entries.add(this.get(propName));
            }
            return Collections.unmodifiableCollection(entries);
        }
    }

    @Override
    public Collection<Name> getPropertyNames() {
        return Collections.unmodifiableCollection(this.properties.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(PropertyEntry propertyEntry) {
        Map<Name, Reference<PropertyEntry>> map = this.properties;
        synchronized (map) {
            SoftReference<PropertyEntry> ref = new SoftReference<PropertyEntry>(propertyEntry);
            this.properties.put(propertyEntry.getName(), ref);
        }
    }

    @Override
    public void addAll(Collection<PropertyEntry> propertyEntries) {
        for (PropertyEntry pe : propertyEntries) {
            this.add(pe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(PropertyEntry propertyEntry) {
        Map<Name, Reference<PropertyEntry>> map = this.properties;
        synchronized (map) {
            Name pName = propertyEntry.getName();
            PropertyEntry pe = this.get(pName);
            if (pe == propertyEntry) {
                this.properties.remove(pName);
                return true;
            }
            return false;
        }
    }
}

