/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.sightly.ui.internal;

import org.apache.sling.ide.eclipse.sightly.SightlyFacetHelper;
import org.apache.sling.ide.eclipse.sightly.model.Attribute;
import org.apache.sling.ide.eclipse.sightly.model.ModelElements;
import org.apache.sling.ide.eclipse.sightly.model.ProposalDescription;
import org.apache.sling.ide.eclipse.sightly.model.Tag;
import org.apache.sling.ide.eclipse.sightly.ui.internal.SharedImages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.eclipse.wst.xml.ui.internal.contentassist.DefaultXMLCompletionProposalComputer;
import org.eclipse.wst.xml.ui.internal.contentassist.MarkupCompletionProposal;

public class ProposalComputer
extends DefaultXMLCompletionProposalComputer {
    protected void addAttributeNameProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        if (ProposalComputer.addSightlyProposals(contentAssistRequest)) {
            String[] stringArray = ModelElements.ATTRIBUTE_NAMES;
            int n = ModelElements.ATTRIBUTE_NAMES.length;
            int n2 = 0;
            while (n2 < n) {
                String attributeName = stringArray[n2];
                this.addAttributeProposal(contentAssistRequest, (ProposalDescription)new Attribute(attributeName));
                ++n2;
            }
        }
        super.addAttributeNameProposals(contentAssistRequest, context);
    }

    protected void addTagInsertionProposals(ContentAssistRequest contentAssistRequest, int childPosition, CompletionProposalInvocationContext context) {
        if (ProposalComputer.addSightlyProposals(contentAssistRequest)) {
            this.addAttributeProposal(contentAssistRequest, (ProposalDescription)new Tag("sly"));
        }
    }

    private void addAttributeProposal(ContentAssistRequest contentAssistRequest, ProposalDescription proposalDescription) {
        String replacementString = proposalDescription.getInsertionText();
        int replacementOffset = contentAssistRequest.getReplacementBeginPosition();
        int replacementLength = contentAssistRequest.getReplacementLength();
        int cursorPosition = ProposalComputer.getCursorPositionForProposedText((String)replacementString);
        MarkupCompletionProposal proposal = new MarkupCompletionProposal(replacementString.toString(), replacementOffset, replacementLength, cursorPosition, SharedImages.SIGHTLY_ICON.createImage(), proposalDescription.getLabel(), null, proposalDescription.getAdditionalInfo(), 1200);
        contentAssistRequest.addProposal((ICompletionProposal)proposal);
    }

    private static boolean addSightlyProposals(ContentAssistRequest request) {
        IDOMNode element = (IDOMNode)request.getNode();
        IFile file = ProposalComputer.getFile((IStructuredModel)element.getModel());
        return SightlyFacetHelper.hasSightlyFacet((IProject)file.getProject());
    }

    public static final IFile getFile(IStructuredModel model) {
        String baselocation = model.getBaseLocation();
        if (baselocation != null) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            Path filePath = new Path(baselocation);
            if (filePath.segmentCount() > 1) {
                return root.getFile((IPath)filePath);
            }
        }
        return null;
    }
}

