/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.oak.server.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.retention.RetentionManager;
import javax.jcr.security.AccessControlManager;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.Oak;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TcclWrappingJackrabbitSession
implements JackrabbitSession {
    private final JackrabbitSession wrapped;

    public TcclWrappingJackrabbitSession(JackrabbitSession wrapped) {
        this.wrapped = wrapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session impersonate(Credentials credentials) throws LoginException, RepositoryException {
        Thread thread = Thread.currentThread();
        ClassLoader oldClassLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(Oak.class.getClassLoader());
        try {
            Session session = this.wrapped.impersonate(credentials);
            TcclWrappingJackrabbitSession tcclWrappingJackrabbitSession = new TcclWrappingJackrabbitSession((JackrabbitSession)session);
            return tcclWrappingJackrabbitSession;
        }
        finally {
            thread.setContextClassLoader(oldClassLoader);
        }
    }

    public Repository getRepository() {
        return this.wrapped.getRepository();
    }

    public String getUserID() {
        return this.wrapped.getUserID();
    }

    public String[] getAttributeNames() {
        return this.wrapped.getAttributeNames();
    }

    public Object getAttribute(String name) {
        return this.wrapped.getAttribute(name);
    }

    public boolean hasPermission(String absPath, String ... actions) throws RepositoryException {
        return this.wrapped.hasPermission(absPath, actions);
    }

    public Workspace getWorkspace() {
        return this.wrapped.getWorkspace();
    }

    public Node getRootNode() throws RepositoryException {
        return this.wrapped.getRootNode();
    }

    public Node getNodeByUUID(String uuid) throws ItemNotFoundException, RepositoryException {
        return this.wrapped.getNodeByUUID(uuid);
    }

    public Node getNodeByIdentifier(String id) throws ItemNotFoundException, RepositoryException {
        return this.wrapped.getNodeByIdentifier(id);
    }

    public Item getItem(String absPath) throws PathNotFoundException, RepositoryException {
        return this.wrapped.getItem(absPath);
    }

    public PrincipalManager getPrincipalManager() throws AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        return this.wrapped.getPrincipalManager();
    }

    public Node getNode(String absPath) throws PathNotFoundException, RepositoryException {
        return this.wrapped.getNode(absPath);
    }

    public Property getProperty(String absPath) throws PathNotFoundException, RepositoryException {
        return this.wrapped.getProperty(absPath);
    }

    public UserManager getUserManager() throws AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        return this.wrapped.getUserManager();
    }

    public boolean itemExists(String absPath) throws RepositoryException {
        return this.wrapped.itemExists(absPath);
    }

    public Item getItemOrNull(String absPath) throws RepositoryException {
        return this.wrapped.getItemOrNull(absPath);
    }

    public boolean nodeExists(String absPath) throws RepositoryException {
        return this.wrapped.nodeExists(absPath);
    }

    public Property getPropertyOrNull(String absPath) throws RepositoryException {
        return this.wrapped.getPropertyOrNull(absPath);
    }

    public boolean propertyExists(String absPath) throws RepositoryException {
        return this.wrapped.propertyExists(absPath);
    }

    public Node getNodeOrNull(String absPath) throws RepositoryException {
        return this.wrapped.getNodeOrNull(absPath);
    }

    public void move(String srcAbsPath, String destAbsPath) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        this.wrapped.move(srcAbsPath, destAbsPath);
    }

    public void removeItem(String absPath) throws VersionException, LockException, ConstraintViolationException, AccessDeniedException, RepositoryException {
        this.wrapped.removeItem(absPath);
    }

    public void save() throws AccessDeniedException, ItemExistsException, ReferentialIntegrityException, ConstraintViolationException, InvalidItemStateException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
        this.wrapped.save();
    }

    public void refresh(boolean keepChanges) throws RepositoryException {
        this.wrapped.refresh(keepChanges);
    }

    public boolean hasPendingChanges() throws RepositoryException {
        return this.wrapped.hasPendingChanges();
    }

    public ValueFactory getValueFactory() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.wrapped.getValueFactory();
    }

    public boolean hasPermission(String absPath, String actions) throws RepositoryException {
        return this.wrapped.hasPermission(absPath, actions);
    }

    public void checkPermission(String absPath, String actions) throws AccessControlException, RepositoryException {
        this.wrapped.checkPermission(absPath, actions);
    }

    public boolean hasCapability(String methodName, Object target, Object[] arguments) throws RepositoryException {
        return this.wrapped.hasCapability(methodName, target, arguments);
    }

    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws PathNotFoundException, ConstraintViolationException, VersionException, LockException, RepositoryException {
        return this.wrapped.getImportContentHandler(parentAbsPath, uuidBehavior);
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior) throws IOException, PathNotFoundException, ItemExistsException, ConstraintViolationException, VersionException, InvalidSerializedDataException, LockException, RepositoryException {
        this.wrapped.importXML(parentAbsPath, in, uuidBehavior);
    }

    public void exportSystemView(String absPath, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws PathNotFoundException, SAXException, RepositoryException {
        this.wrapped.exportSystemView(absPath, contentHandler, skipBinary, noRecurse);
    }

    public void exportSystemView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws IOException, PathNotFoundException, RepositoryException {
        this.wrapped.exportSystemView(absPath, out, skipBinary, noRecurse);
    }

    public void exportDocumentView(String absPath, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws PathNotFoundException, SAXException, RepositoryException {
        this.wrapped.exportDocumentView(absPath, contentHandler, skipBinary, noRecurse);
    }

    public void exportDocumentView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws IOException, PathNotFoundException, RepositoryException {
        this.wrapped.exportDocumentView(absPath, out, skipBinary, noRecurse);
    }

    public void setNamespacePrefix(String prefix, String uri) throws NamespaceException, RepositoryException {
        this.wrapped.setNamespacePrefix(prefix, uri);
    }

    public String[] getNamespacePrefixes() throws RepositoryException {
        return this.wrapped.getNamespacePrefixes();
    }

    public String getNamespaceURI(String prefix) throws NamespaceException, RepositoryException {
        return this.wrapped.getNamespaceURI(prefix);
    }

    public String getNamespacePrefix(String uri) throws NamespaceException, RepositoryException {
        return this.wrapped.getNamespacePrefix(uri);
    }

    public void logout() {
        this.wrapped.logout();
    }

    public boolean isLive() {
        return this.wrapped.isLive();
    }

    public void addLockToken(String lt) {
        this.wrapped.addLockToken(lt);
    }

    public String[] getLockTokens() {
        return this.wrapped.getLockTokens();
    }

    public void removeLockToken(String lt) {
        this.wrapped.removeLockToken(lt);
    }

    public AccessControlManager getAccessControlManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.wrapped.getAccessControlManager();
    }

    public RetentionManager getRetentionManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.wrapped.getRetentionManager();
    }
}

