/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.sling.api.resource.runtime.dto.AuthType;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderHandler;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderInfo;
import org.apache.sling.resourceresolver.impl.providers.tree.PathTree;
import org.apache.sling.spi.resource.provider.ResourceProvider;

public class ResourceProviderStorage {
    private final List<ResourceProviderHandler> allHandlers;
    private final List<ResourceProviderHandler> authRequiredHandlers;
    private final List<ResourceProviderHandler> adaptableHandlers;
    private final List<ResourceProviderHandler> attributableHandlers;
    private final List<ResourceProviderHandler> languageQueryableHandlers;
    private final PathTree<ResourceProviderHandler> handlersTree;

    public ResourceProviderStorage(List<ResourceProviderHandler> handlers) {
        this.allHandlers = handlers;
        this.authRequiredHandlers = new ArrayList<ResourceProviderHandler>();
        this.adaptableHandlers = new ArrayList<ResourceProviderHandler>();
        this.attributableHandlers = new ArrayList<ResourceProviderHandler>();
        this.languageQueryableHandlers = new ArrayList<ResourceProviderHandler>();
        for (ResourceProviderHandler h : this.allHandlers) {
            ResourceProvider<Object> rp;
            ResourceProviderInfo info = h.getInfo();
            if (info.getAuthType() == AuthType.required) {
                this.authRequiredHandlers.add(h);
            }
            if (info.isAdaptable()) {
                this.adaptableHandlers.add(h);
            }
            if (info.isAttributable()) {
                this.attributableHandlers.add(h);
            }
            if ((rp = h.getResourceProvider()) == null || rp.getQueryLanguageProvider() == null) continue;
            this.languageQueryableHandlers.add(h);
        }
        Comparator<ResourceProviderHandler> comp = new Comparator<ResourceProviderHandler>(){

            @Override
            public int compare(ResourceProviderHandler o1, ResourceProviderHandler o2) {
                ResourceProviderInfo i1 = o1.getInfo();
                ResourceProviderInfo i2 = o2.getInfo();
                if (i1 == null) {
                    return i2 == null ? 0 : -1;
                }
                if (i2 == null) {
                    return 1;
                }
                return i2.getServiceReference().compareTo(i1.getServiceReference());
            }
        };
        Collections.sort(this.authRequiredHandlers, comp);
        Collections.sort(this.adaptableHandlers, comp);
        Collections.sort(this.attributableHandlers, comp);
        Collections.sort(this.languageQueryableHandlers, comp);
        this.handlersTree = new PathTree<ResourceProviderHandler>(handlers);
    }

    public List<ResourceProviderHandler> getAllHandlers() {
        return this.allHandlers;
    }

    public List<ResourceProviderHandler> getAuthRequiredHandlers() {
        return this.authRequiredHandlers;
    }

    public List<ResourceProviderHandler> getAdaptableHandlers() {
        return this.adaptableHandlers;
    }

    public List<ResourceProviderHandler> getAttributableHandlers() {
        return this.attributableHandlers;
    }

    public List<ResourceProviderHandler> getLanguageQueryableHandlers() {
        return this.languageQueryableHandlers;
    }

    public PathTree<ResourceProviderHandler> getTree() {
        return this.handlersTree;
    }
}

