/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import java.security.Principal;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.principal.GroupPrincipal;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.tree.TreeAware;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.security.user.AuthorizableImpl;
import org.apache.jackrabbit.oak.security.user.UserManagerImpl;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.principal.GroupPrincipals;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    private Utils() {
    }

    @NotNull
    static Tree getOrAddTree(@NotNull Tree tree, @NotNull String relativePath, @NotNull String primaryTypeName) throws AccessDeniedException {
        if (PathUtils.denotesCurrent(relativePath)) {
            return tree;
        }
        if (PathUtils.denotesParent(relativePath)) {
            return tree.getParent();
        }
        if (relativePath.indexOf(47) == -1) {
            return TreeUtil.getOrAddChild(tree, relativePath, primaryTypeName);
        }
        for (String element : PathUtils.elements(relativePath)) {
            if (PathUtils.denotesParent(element)) {
                tree = tree.getParent();
                continue;
            }
            if (PathUtils.denotesCurrent(element)) continue;
            tree = TreeUtil.getOrAddChild(tree, element, primaryTypeName);
        }
        return tree;
    }

    static boolean canHavePasswordExpired(@NotNull String userId, @NotNull ConfigurationParameters config) {
        return !UserUtil.isAdmin(config, userId) || config.getConfigValue("passwordExpiryForAdmin", false) != false;
    }

    static boolean canHavePasswordExpired(@NotNull User user, @NotNull ConfigurationParameters config) {
        return !user.isAdmin() || config.getConfigValue("passwordExpiryForAdmin", false) != false;
    }

    static boolean isEveryone(@NotNull Authorizable authorizable) {
        return authorizable.isGroup() && "everyone".equals(Utils.getPrincipalName(authorizable));
    }

    public static boolean canImpersonateAllUsers(@NotNull Principal principal, @NotNull UserManager userManager) {
        try {
            Authorizable authorizable = userManager.getAuthorizable(principal);
            if (authorizable == null || authorizable.isGroup()) {
                return false;
            }
            User user = (User)authorizable;
            return user.isAdmin() || Utils.isImpersonator(user, userManager);
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage());
            return false;
        }
    }

    private static boolean isImpersonator(@NotNull User user, @NotNull UserManager userManager) throws RepositoryException {
        if (!(userManager instanceof UserManagerImpl)) {
            return false;
        }
        UserManagerImpl umImpl = (UserManagerImpl)userManager;
        Set<String> impersonatorPrincipals = Set.of(umImpl.getConfig().getConfigValue("impersonatorPrincipals", new String[0]));
        if (impersonatorPrincipals.isEmpty()) {
            return false;
        }
        Principal userPrincipal = user.getPrincipal();
        PrincipalManager principalManager = umImpl.getPrincipalManager();
        for (String impersonatorPrincipalName : impersonatorPrincipals) {
            Principal impersonatorPrincipal = principalManager.getPrincipal(impersonatorPrincipalName);
            if (impersonatorPrincipal == null || !(GroupPrincipals.isGroup(impersonatorPrincipal) ? ((GroupPrincipal)impersonatorPrincipal).isMember(userPrincipal) : impersonatorPrincipalName.equals(userPrincipal.getName()))) continue;
            return true;
        }
        return false;
    }

    public static boolean isAdmin(@NotNull Principal principal, @NotNull UserManager userManager) {
        try {
            Authorizable authorizable = userManager.getAuthorizable(principal);
            if (authorizable == null || authorizable.isGroup()) {
                return false;
            }
            return ((User)authorizable).isAdmin();
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage());
            return false;
        }
    }

    @Nullable
    private static String getPrincipalName(@NotNull Authorizable authorizable) {
        if (authorizable instanceof AuthorizableImpl) {
            return ((AuthorizableImpl)authorizable).getPrincipalNameOrNull();
        }
        try {
            return authorizable.getPrincipal().getName();
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    @Nullable
    static String getIdOrNull(@NotNull Authorizable authorizable) {
        try {
            return authorizable.getID();
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    @NotNull
    static Tree getTree(@NotNull Authorizable authorizable, @NotNull Root root) throws RepositoryException {
        if (authorizable instanceof TreeAware) {
            return ((TreeAware)((Object)authorizable)).getTree();
        }
        return root.getTree(authorizable.getPath());
    }
}

