/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.privilege;

import java.util.Collections;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JcrAllUtil {
    public static final long DYNAMIC_JCR_ALL_VALUE = -1L;

    private JcrAllUtil() {
    }

    public static PrivilegeBits getPrivilegeBits(@Nullable PropertyState propertyState, @NotNull PrivilegeBitsProvider provider) {
        return JcrAllUtil.denotesDynamicJcrAll(propertyState) ? JcrAllUtil.getAllBits(provider) : PrivilegeBits.getInstance(propertyState);
    }

    public static PropertyState asPropertyState(@NotNull String name, @NotNull PrivilegeBits bits, @NotNull PrivilegeBitsProvider provider) {
        if (!bits.isBuiltin() && bits.includes(JcrAllUtil.getAllBits(provider))) {
            return PropertyStates.createProperty(name, Collections.singletonList(-1L), Type.LONGS);
        }
        return bits.asPropertyState(name);
    }

    public static boolean denotesDynamicJcrAll(@Nullable PropertyState property) {
        return property != null && Type.LONGS == property.getType() && property.count() == 1 && property.getValue(Type.LONG, 0) == -1L;
    }

    private static PrivilegeBits getAllBits(@NotNull PrivilegeBitsProvider provider) {
        return provider.getBits(Collections.singleton("jcr:all"));
    }
}

