/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.sling.MockJcrSlingRepository;
import org.apache.sling.testing.mock.sling.MockSling;
import org.apache.sling.testing.mock.sling.NodeTypeMode;
import org.apache.sling.testing.mock.sling.servlet.MockSlingHttpServletRequest;
import org.apache.sling.testing.mock.sling.servlet.MockSlingHttpServletResponse;
import org.apache.sling.testing.mock.sling.servlet.MockSlingJakartaHttpServletRequest;
import org.apache.sling.testing.mock.sling.servlet.MockSlingJakartaHttpServletResponse;
import org.apache.sling.testing.mock.sling.spi.ResourceResolverTypeAdapter;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.BundleContext;

public class MockSlingTest {
    private SlingRepository buildRepo(ResourceResolverTypeAdapter adapter) {
        BundleContext context = MockOsgi.newBundleContext();
        MockSling.buildFactoryFromRepository((NodeTypeMode)NodeTypeMode.NOT_SUPPORTED, (BundleContext)context, (ResourceResolverTypeAdapter)adapter);
        return (SlingRepository)context.getService(context.getServiceReference(SlingRepository.class));
    }

    @Test
    public void testAdapterDoesNotSupportSnapshots() {
        ResourceResolverTypeAdapter snapshotUnawareAdapter = new ResourceResolverTypeAdapter(){

            @Nullable
            public ResourceResolverFactory newResourceResolverFactory() {
                return null;
            }

            public SlingRepository newSlingRepository() {
                return new MockJcrSlingRepository();
            }
        };
        SlingRepository repo1 = this.buildRepo(snapshotUnawareAdapter);
        SlingRepository repo2 = this.buildRepo(snapshotUnawareAdapter);
        Assert.assertNotNull((Object)repo1);
        Assert.assertNotNull((Object)repo2);
        Assert.assertNotSame((Object)repo2, (Object)repo1);
    }

    @Test
    public void testAdapterSupportsSnapshots() {
        MockJcrSlingRepository freshRepo = new MockJcrSlingRepository();
        MockJcrSlingRepository snapshotRepo = new MockJcrSlingRepository();
        ResourceResolverTypeAdapter snapshotAwareAdapter = new ResourceResolverTypeAdapter(){
            final /* synthetic */ SlingRepository val$freshRepo;
            final /* synthetic */ SlingRepository val$snapshotRepo;
            {
                this.val$freshRepo = slingRepository;
                this.val$snapshotRepo = slingRepository2;
            }

            @Nullable
            public ResourceResolverFactory newResourceResolverFactory() {
                return null;
            }

            public SlingRepository newSlingRepository() {
                return this.val$freshRepo;
            }

            public Object snapshot(SlingRepository repository) {
                return "dummy";
            }

            public SlingRepository newSlingRepositoryFromSnapshot(Object snapshot) {
                return this.val$snapshotRepo;
            }
        };
        SlingRepository repo1 = this.buildRepo(snapshotAwareAdapter);
        SlingRepository repo2 = this.buildRepo(snapshotAwareAdapter);
        Assert.assertSame((Object)freshRepo, (Object)repo1);
        Assert.assertSame((Object)snapshotRepo, (Object)repo2);
    }

    @Deprecated(since="4.1.0")
    @Test
    public void testNewSlingScriptHelperSlingHttpServletRequestSlingHttpServletResponseBundleContext() {
        BundleContext bundleContext = MockOsgi.newBundleContext();
        MockSlingHttpServletRequest javaxRequest = new MockSlingHttpServletRequest(new MockSlingJakartaHttpServletRequest(bundleContext));
        MockSlingHttpServletResponse javaxResponse = new MockSlingHttpServletResponse(new MockSlingJakartaHttpServletResponse());
        Assert.assertNotNull((Object)MockSling.newSlingScriptHelper((SlingHttpServletRequest)javaxRequest, (SlingHttpServletResponse)javaxResponse, (BundleContext)bundleContext));
    }

    @Test
    public void testNewSlingScriptHelperSlingJakartaHttpServletRequestSlingJakartaHttpServletResponseBundleContext() {
        BundleContext bundleContext = MockOsgi.newBundleContext();
        MockSlingJakartaHttpServletRequest jakartaRequest = new MockSlingJakartaHttpServletRequest(bundleContext);
        MockSlingJakartaHttpServletResponse jakartaResponse = new MockSlingJakartaHttpServletResponse();
        Assert.assertNotNull((Object)MockSling.newSlingScriptHelper((SlingJakartaHttpServletRequest)jakartaRequest, (SlingJakartaHttpServletResponse)jakartaResponse, (BundleContext)bundleContext));
    }

    @Deprecated(since="4.1.0")
    @Test
    public void testNewSlingScriptHelperBundleContext() {
        BundleContext bundleContext = MockOsgi.newBundleContext();
        Assert.assertNotNull((Object)MockSling.newSlingScriptHelper((BundleContext)bundleContext));
    }

    @Test
    public void testNewJakartaSlingScriptHelper() {
        BundleContext bundleContext = MockOsgi.newBundleContext();
        Assert.assertNotNull((Object)MockSling.newJakartaSlingScriptHelper((BundleContext)bundleContext));
    }

    @Test
    public void testNewResourceResolverFactoryBundleContext() {
        BundleContext bundleContext = MockOsgi.newBundleContext();
        Assert.assertNotNull((Object)MockSling.newResourceResolverFactory((BundleContext)bundleContext));
    }
}

