/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.xss.impl;

import org.apache.sling.xss.impl.PolicyHandler;
import org.apache.sling.xss.impl.XSSFilterRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainTextToHtmlContentContext
implements XSSFilterRule {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean check(PolicyHandler policy, String str) {
        return true;
    }

    @Override
    public String filter(PolicyHandler policy, String str) {
        String cleaned = PlainTextToHtmlContentContext.escapeXml(str);
        this.log.debug("Protecting (plain text -> HTML) :\n{}\nto\n{}", (Object)str, (Object)cleaned);
        return cleaned;
    }

    private static String escapeXml(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder b = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '&') {
                b.append("&amp;");
                continue;
            }
            if (c == '<') {
                b.append("&lt;");
                continue;
            }
            if (c == '>') {
                b.append("&gt;");
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    @Override
    public boolean supportsPolicy() {
        return false;
    }
}

