/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.xss.impl.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.sling.xss.impl.InvalidConfigException;
import org.apache.sling.xss.impl.xml.AllowedEmptyTags;
import org.apache.sling.xss.impl.xml.AntiSamyPolicy;
import org.apache.sling.xss.impl.xml.AntiSamyRules;
import org.apache.sling.xss.impl.xml.Attribute;
import org.apache.sling.xss.impl.xml.Directive;
import org.apache.sling.xss.impl.xml.Literal;
import org.apache.sling.xss.impl.xml.Property;
import org.apache.sling.xss.impl.xml.Regexp;
import org.apache.sling.xss.impl.xml.Tag;

class MapBuilder {
    AntiSamyPolicy policy;
    private static final List<String> ALLOWED_EMPTY_TAGS = Arrays.asList("br", "hr", "a", "img", "link", "iframe", "script", "object", "applet", "frame", "base", "param", "meta", "input", "textarea", "embed", "basefont", "col");

    MapBuilder() {
    }

    public void createRulesMap(AntiSamyPolicy policy, AntiSamyRules topLevelElement) throws InvalidConfigException {
        this.policy = policy;
        this.parseCommonRegExps(topLevelElement.getRegexpList());
        this.parseDirectives(topLevelElement.getDirectiveList());
        this.parseAllowedEmptyTags(topLevelElement.getAllowedEmptyTags());
        this.parseCommonAttributes(topLevelElement.getCommonAttributeList());
        this.parseGlobalAttributes(topLevelElement.getGlobalTagAttributes().getGlobalTagAttributeList());
        this.parseDynamicAttributes(topLevelElement.getDynamicTagAttribute().getDynamicTagAttributeList());
        this.parseTagRules(topLevelElement.getTagRulesList());
        this.parseCSSRules(topLevelElement.getPropertyList());
    }

    private void parseCommonRegExps(List<Regexp> root) {
        for (Regexp regex : root) {
            String name = regex.getName();
            Pattern regexp = Pattern.compile(regex.getValue(), 32);
            this.policy.commonRegularExpressions.put(name, regexp);
        }
    }

    private void parseDirectives(List<Directive> root) {
        for (Directive directive : root) {
            String name = directive.getName();
            String value = directive.getValue();
            this.policy.directives.put(name, value);
        }
    }

    private void parseCommonAttributes(List<Attribute> root) {
        for (Attribute attribute : root) {
            List<Regexp> allowedRegexps = this.getAllowedRegexps(attribute.getRegexpList());
            Attribute newAttribute = new Attribute(attribute.getName(), allowedRegexps, attribute.getLiteralList(), attribute.getOnInvalid(), attribute.getDescription());
            this.policy.commonAttributes.put(attribute.getName(), newAttribute);
        }
    }

    private void parseAllowedEmptyTags(AllowedEmptyTags allowedEmptyTagsList) {
        if (allowedEmptyTagsList != null) {
            this.policy.allowedEmptyTags = allowedEmptyTagsList.getLiterals();
        } else {
            this.policy.allowedEmptyTags.addAll(ALLOWED_EMPTY_TAGS);
        }
    }

    private void parseGlobalAttributes(List<Attribute> root) throws InvalidConfigException {
        for (Attribute ele : root) {
            String name = ele.getName();
            Attribute toAdd = this.policy.commonAttributes.get(name);
            if (toAdd != null) {
                this.policy.globalAttributes.put(name, toAdd);
                continue;
            }
            throw new InvalidConfigException("Global attribute '" + name + "' was not defined in <common-attributes>");
        }
    }

    private void parseDynamicAttributes(List<Attribute> root) throws InvalidConfigException {
        for (Attribute ele : root) {
            String name = ele.getName();
            Attribute toAdd = this.policy.getCommonAttributes().get(name);
            if (toAdd != null) {
                String attrName = name.substring(0, name.length() - 1);
                this.policy.getDynamicAttributes().put(attrName, toAdd);
                continue;
            }
            throw new InvalidConfigException("Dynamic attribute '" + name + "' was not defined in <common-attributes>");
        }
    }

    private void parseTagRules(List<Tag> root) throws InvalidConfigException {
        if (root == null) {
            return;
        }
        for (Tag tagNode : root) {
            String name = tagNode.getName();
            String action = tagNode.getAction();
            List<Attribute> attributeList = tagNode.getAttributeList();
            List<Attribute> tagAttributes = this.getTagAttributes(attributeList, name);
            Tag tag = new Tag(name, action, tagAttributes);
            this.policy.tagRules.put(name, tag);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Attribute> getTagAttributes(List<Attribute> attributeList, String tagName) throws InvalidConfigException {
        ArrayList<Attribute> tagAttributes = new ArrayList<Attribute>();
        for (Attribute attribute : attributeList) {
            Attribute newAttribute;
            String attributeName = attribute.getName();
            List<Regexp> regexps = attribute.getRegexpList();
            List<Literal> literals = attribute.getLiteralList();
            String onInvalid = attribute.getOnInvalid();
            String description = attribute.getDescription();
            if (regexps.isEmpty() && literals.isEmpty()) {
                Attribute commonAttribute = this.policy.commonAttributes.get(attributeName);
                if (commonAttribute == null) throw new InvalidConfigException("Attribute '" + attributeName + "' was referenced as a common attribute in definition of '" + tagName + "', but does not exist in <common-attributes>");
                newAttribute = new Attribute(attributeName, !regexps.isEmpty() ? regexps : commonAttribute.getRegexpList(), !literals.isEmpty() ? literals : commonAttribute.getLiteralList(), !onInvalid.isEmpty() ? onInvalid : commonAttribute.getOnInvalid(), !description.isEmpty() ? description : commonAttribute.getDescription());
            } else {
                List<Regexp> commonAllowedRegexps = this.getAllowedRegexps(regexps);
                List<Literal> allowedValues = attribute.getLiteralList();
                newAttribute = new Attribute(attributeName, commonAllowedRegexps, allowedValues, onInvalid, description);
            }
            tagAttributes.add(newAttribute);
        }
        return tagAttributes;
    }

    private void parseCSSRules(List<Property> root) {
        for (Property property : root) {
            List<Regexp> allowedRegexp3 = this.getAllowedRegexps(property.getRegexpList());
            Property propertyWithPatterns = new Property(property.getName(), allowedRegexp3, property.getLiteralList(), property.getShorthandList(), property.getDescription(), property.getOnInvalid(), property.getDefaultValue());
            this.policy.getCssRules().put(property.getName(), propertyWithPatterns);
        }
    }

    private List<Regexp> getAllowedRegexps(List<Regexp> nameAndRegexpsList) {
        ArrayList<Regexp> allowedRegExp = new ArrayList<Regexp>();
        for (Regexp regExpNode : nameAndRegexpsList) {
            String regExpName = regExpNode.getName();
            String value = regExpNode.getValue();
            if (regExpName != null && regExpName.length() > 0) {
                allowedRegExp.add(new Regexp(regExpName, this.policy.getCommonRegularExpressions().get(regExpName).toString()));
                continue;
            }
            if (value == null) continue;
            allowedRegExp.add(new Regexp(regExpName, value));
        }
        return allowedRegExp;
    }
}

