/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.waf.rules;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.esapi.waf.actions.Action;
import org.owasp.esapi.waf.actions.DefaultAction;
import org.owasp.esapi.waf.actions.DoNothingAction;
import org.owasp.esapi.waf.configuration.AppGuardianConfiguration;
import org.owasp.esapi.waf.internal.InterceptingHTTPServletResponse;
import org.owasp.esapi.waf.rules.Rule;

public class DetectOutboundContentRule
extends Rule {
    private Pattern contentType;
    private Pattern pattern;
    private Pattern uri;

    public DetectOutboundContentRule(String id, Pattern contentType, Pattern pattern, Pattern uri) {
        this.contentType = contentType;
        this.pattern = pattern;
        this.uri = uri;
        this.setId(id);
    }

    @Override
    public Action check(HttpServletRequest request, InterceptingHTTPServletResponse response, HttpServletResponse httpResponse) {
        String charEnc;
        String inboundContentType;
        if (this.uri != null && !this.uri.matcher(request.getRequestURI()).matches()) {
            return new DoNothingAction();
        }
        if (response != null) {
            if (response.getContentType() == null) {
                response.setContentType(AppGuardianConfiguration.DEFAULT_CONTENT_TYPE);
            }
            inboundContentType = response.getContentType();
            charEnc = response.getCharacterEncoding();
        } else {
            if (httpResponse.getContentType() == null) {
                httpResponse.setContentType(AppGuardianConfiguration.DEFAULT_CONTENT_TYPE);
            }
            inboundContentType = httpResponse.getContentType();
            charEnc = httpResponse.getCharacterEncoding();
        }
        if (this.contentType.matcher(inboundContentType).matches()) {
            try {
                byte[] bytes = null;
                try {
                    bytes = response.getInterceptingServletOutputStream().getResponseBytes();
                }
                catch (IOException ioe) {
                    this.log(request, "Error matching pattern '" + this.pattern.pattern() + "', IOException encountered (possibly too large?): " + ioe.getMessage() + " (in response to URL: '" + request.getRequestURL() + "')");
                    return new DoNothingAction();
                }
                String s = new String(bytes, charEnc);
                if (this.pattern.matcher(s).matches()) {
                    this.log(request, "Content pattern '" + this.pattern.pattern() + "' was found in response to URL: '" + request.getRequestURL() + "'");
                    return new DefaultAction();
                }
            }
            catch (UnsupportedEncodingException uee) {
                this.log(request, "Content pattern '" + this.pattern.pattern() + "' could not be found due to encoding error: " + uee.getMessage());
            }
        }
        return new DoNothingAction();
    }
}

