/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metric;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.storm.metric.FileBasedEventLogger;
import org.apache.storm.metric.IEventLogger;
import org.apache.storm.task.IBolt;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.tuple.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventLoggerBolt
implements IBolt {
    public static final String FIELD_TS = "ts";
    public static final String FIELD_VALUES = "values";
    public static final String FIELD_COMPONENT_ID = "component-id";
    public static final String FIELD_MESSAGE_ID = "message-id";
    private static final Logger LOG = LoggerFactory.getLogger(EventLoggerBolt.class);
    private List<IEventLogger> eventLoggers;

    @Override
    public void prepare(Map<String, Object> topoConf, TopologyContext context, OutputCollector collector) {
        LOG.info("EventLoggerBolt prepare called");
        this.eventLoggers = new ArrayList<IEventLogger>();
        List registerInfo = (List)topoConf.get("topology.event.logger.register");
        if (registerInfo != null && !registerInfo.isEmpty()) {
            this.initializeEventLoggers(topoConf, context, registerInfo);
        } else {
            this.initializeDefaultEventLogger(topoConf, context);
        }
    }

    @Override
    public void execute(Tuple input) {
        LOG.debug("** EventLoggerBolt got tuple from sourceComponent {}, with values {}", (Object)input.getSourceComponent(), input.getValues());
        Object msgId = input.getValueByField(FIELD_MESSAGE_ID);
        IEventLogger.EventInfo eventInfo = new IEventLogger.EventInfo(input.getLongByField(FIELD_TS), input.getSourceComponent(), input.getSourceTask(), msgId, (List)input.getValueByField(FIELD_VALUES));
        for (IEventLogger eventLogger : this.eventLoggers) {
            eventLogger.log(eventInfo);
        }
    }

    @Override
    public void cleanup() {
        for (IEventLogger eventLogger : this.eventLoggers) {
            eventLogger.close();
        }
    }

    private void initializeEventLoggers(Map<String, Object> topoConf, TopologyContext context, List<Map<String, Object>> registerInfo) {
        for (Map<String, Object> info : registerInfo) {
            IEventLogger eventLogger;
            String className = (String)info.get("class");
            Map arguments = (Map)info.get("arguments");
            try {
                eventLogger = (IEventLogger)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not instantiate a class listed in config under section topology.event.logger.register with fully qualified name " + className, e);
            }
            eventLogger.prepare(topoConf, arguments, context);
            this.eventLoggers.add(eventLogger);
        }
    }

    private void initializeDefaultEventLogger(Map<String, Object> topoConf, TopologyContext context) {
        FileBasedEventLogger eventLogger = new FileBasedEventLogger();
        eventLogger.prepare(topoConf, null, context);
        this.eventLoggers.add(eventLogger);
    }
}

