/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.InetAddress;
import java.security.Principal;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.Subject;
import org.apache.storm.shade.com.google.common.annotations.VisibleForTesting;

public class ReqContext {
    private static final MethodHandle CURRENT = ReqContext.lookupCurrent();
    private static final AtomicInteger uniqueId = new AtomicInteger(0);
    private static final ThreadLocal<ReqContext> ctxt = ThreadLocal.withInitial(ReqContext::new);
    private Subject subject;
    private InetAddress remoteAddr;
    private final int reqId;
    private Principal realPrincipal;

    @VisibleForTesting
    public ReqContext() {
        this.subject = ReqContext.currentSubject();
        this.reqId = uniqueId.incrementAndGet();
    }

    @VisibleForTesting
    public ReqContext(Subject sub) {
        this.subject = sub;
        this.reqId = uniqueId.incrementAndGet();
    }

    @VisibleForTesting
    public ReqContext(ReqContext other) {
        this.subject = other.subject;
        this.remoteAddr = other.remoteAddr;
        this.reqId = other.reqId;
        this.realPrincipal = other.realPrincipal;
    }

    public static ReqContext context() {
        return ctxt.get();
    }

    public static void reset() {
        ctxt.remove();
    }

    public String toString() {
        return "ReqContext{realPrincipal=" + (this.realPrincipal != null ? this.realPrincipal.getName() : "null") + ", reqId=" + this.reqId + ", remoteAddr=" + String.valueOf(this.remoteAddr) + ", authZPrincipal=" + (this.principal() != null ? this.principal().getName() : "null") + ", ThreadId=" + Thread.currentThread().toString() + "}";
    }

    public void setRemoteAddress(InetAddress addr) {
        this.remoteAddr = addr;
    }

    public InetAddress remoteAddress() {
        return this.remoteAddr;
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public Subject subject() {
        return this.subject;
    }

    public Principal principal() {
        if (this.subject == null) {
            return null;
        }
        Set<Principal> princs = this.subject.getPrincipals();
        if (princs.size() == 0) {
            return null;
        }
        return (Principal)princs.toArray()[0];
    }

    public void setRealPrincipal(Principal realPrincipal) {
        this.realPrincipal = realPrincipal;
    }

    public Principal realPrincipal() {
        return this.realPrincipal;
    }

    public boolean isImpersonating() {
        return this.realPrincipal != null && !this.realPrincipal.equals(this.principal());
    }

    public int requestID() {
        return this.reqId;
    }

    public static Subject currentSubject() {
        try {
            return CURRENT.invoke();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static MethodHandle lookupCurrent() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            return lookup.findStatic(Subject.class, "current", MethodType.methodType(Subject.class));
        }
        catch (NoSuchMethodException e) {
            MethodHandle getContext = ReqContext.lookupGetContext();
            MethodHandle getSubject = ReqContext.lookupGetSubject();
            return MethodHandles.filterReturnValue(getContext, getSubject);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static MethodHandle lookupGetSubject() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            Class<?> contextClazz = ClassLoader.getSystemClassLoader().loadClass("java.security.AccessControlContext");
            return lookup.findStatic(Subject.class, "getSubject", MethodType.methodType(Subject.class, contextClazz));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static MethodHandle lookupGetContext() {
        try {
            Class<?> controllerClazz = ClassLoader.getSystemClassLoader().loadClass("java.security.AccessController");
            Class<?> contextClazz = ClassLoader.getSystemClassLoader().loadClass("java.security.AccessControlContext");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            return lookup.findStatic(controllerClazz, "getContext", MethodType.methodType(contextClazz));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }
}

