/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.stats;

import java.util.Map;
import org.apache.storm.generated.ExecutorStats;
import org.apache.storm.metric.internal.MultiCountStat;
import org.apache.storm.metric.internal.MultiLatencyStat;

public abstract class CommonStats {
    protected final int rate;
    private final MultiCountStat emittedStats;
    private final MultiCountStat transferredStats;
    private final MultiCountStat ackedStats;
    private final MultiCountStat failedStats;

    public CommonStats(int rate, int numStatBuckets) {
        this.rate = rate;
        this.emittedStats = new MultiCountStat(numStatBuckets);
        this.transferredStats = new MultiCountStat(numStatBuckets);
        this.ackedStats = new MultiCountStat(numStatBuckets);
        this.failedStats = new MultiCountStat(numStatBuckets);
    }

    public MultiCountStat getFailed() {
        return this.failedStats;
    }

    public MultiCountStat getAcked() {
        return this.ackedStats;
    }

    public int getRate() {
        return this.rate;
    }

    public MultiCountStat getEmitted() {
        return this.emittedStats;
    }

    public MultiCountStat getTransferred() {
        return this.transferredStats;
    }

    public void emittedTuple(String stream) {
        this.getEmitted().incBy(stream, this.rate);
    }

    public void transferredTuples(String stream, int amount) {
        this.getTransferred().incBy(stream, this.rate * amount);
    }

    public void cleanupStats() {
        this.emittedStats.close();
        this.transferredStats.close();
        this.ackedStats.close();
        this.failedStats.close();
    }

    protected Map<String, Map<String, Long>> valueStat(MultiCountStat metric) {
        return metric.getTimeCounts();
    }

    protected Map<String, Map<String, Double>> valueStat(MultiLatencyStat metric) {
        return metric.getTimeLatAvg();
    }

    public abstract ExecutorStats renderStats();
}

