/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.streams;

import java.util.ArrayList;
import java.util.List;
import org.apache.storm.shade.org.jgrapht.DirectedGraph;
import org.apache.storm.streams.Edge;
import org.apache.storm.streams.Node;
import org.apache.storm.tuple.Fields;

public class StreamUtil {
    public static <T> List<T> getParents(DirectedGraph<Node, Edge> graph, Node node) {
        ArrayList incoming = new ArrayList(graph.incomingEdgesOf((Object)node));
        ArrayList<Node> ret = new ArrayList<Node>();
        for (Edge e : incoming) {
            ret.add(e.getSource());
        }
        return ret;
    }

    public static <T> List<T> getChildren(DirectedGraph<Node, Edge> graph, Node node) {
        ArrayList outgoing = new ArrayList(graph.outgoingEdgesOf((Object)node));
        ArrayList<Node> ret = new ArrayList<Node>();
        for (Edge e : outgoing) {
            ret.add(e.getTarget());
        }
        return ret;
    }

    public static boolean isPunctuation(Object value) {
        return "__punctuation".equals(value);
    }

    public static String getPunctuationStream(String stream) {
        return stream + "__punctuation";
    }

    public static String getSourceStream(String stream) {
        int idx = stream.lastIndexOf("__punctuation");
        if (idx > 0) {
            return stream.substring(0, idx);
        }
        return stream;
    }

    public static Fields getPunctuationFields() {
        return new Fields("__punctuation");
    }
}

